<?php

namespace Mbe\Shipping\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\DB\Ddl\Table;

class InstallSchema implements InstallSchemaInterface
{
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        if (!$installer->tableExists('mbeshippingrate')) {
            $table = $installer->getConnection()->newTable(
                $installer->getTable('mbeshippingrate')
            )
                ->addColumn(
                    'id_mbeshippingrate',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'identity' => true,
                        'nullable' => false,
                        'primary'  => true,
                        'unsigned' => true,
                    ],
                    'Mbe Shipping Rate ID'
                )
                ->addColumn(
                    'country',
                    Table::TYPE_TEXT,
                    4,
                    [],
                    'Country'
                )
                ->addColumn(
                    'region',
                    Table::TYPE_TEXT,
                    30,
                    [],
                    'Region'
                )
                ->addColumn(
                    'city',
                    Table::TYPE_TEXT,
                    30,
                    [],
                    'City'
                )
                ->addColumn(
                    'zip',
                    Table::TYPE_TEXT,
                    10,
                    [],
                    'Zip'
                )
                ->addColumn(
                    'zip_to',
                    Table::TYPE_TEXT,
                    10,
                    [],
                    'Zip to'
                )
                ->addColumn(
                    'weight_from',
                    Table::TYPE_DECIMAL,
                    [12, 4],
                    ['default' => 0.0000],
                    'Weight From'
                )
                ->addColumn(
                    'weight_to',
                    Table::TYPE_DECIMAL,
                    [12, 4],
                    ['default' => 0.0000],
                    'Weight To'
                )
                ->addColumn(
                    'price',
                    Table::TYPE_DECIMAL,
                    [12, 4],
                    ['default' => 0.0000],
                    'Price'
                )
                ->addColumn(
                    'delivery_type',
                    Table::TYPE_TEXT,
                    255,
                    [],
                    'Delivery Type'
                )
                ->setComment('Mbe Shipping Rates Table');
            $installer->getConnection()->createTable($table);
        }

        if ($installer->tableExists('sales_order')) {
            if ($installer->getConnection()->tableColumnExists($installer->getTable('sales_order'), 'is_mbe_custom_mapping') === false) {
                $installer->getConnection()->addColumn(
                    $installer->getTable('sales_order'),
                    'is_mbe_custom_mapping',
                    [
                        'type'     => Table::TYPE_BOOLEAN,
                        'nullable' => false,
                        'default'  => false,
                        'comment'  => 'MBE Custom mapping shipment order',
                    ]
                );
            }

            $uapColumnName = 'mbe_shipping_uap_shipment';
            if ($installer->getConnection()->tableColumnExists($installer->getTable('sales_order'), $uapColumnName) === false) {
                $uapColumnDefinition = [
                    'type' => Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'default' => false,
                    'comment' => 'MBE Shipment Ship to UAP',
                ];
                $installer->getConnection()->addColumn(
                    $installer->getTable('sales_order'),
                    $uapColumnName,
                    $uapColumnDefinition
                );
                $installer->getConnection()->addColumn(
                    $installer->getTable('quote'),
                    $uapColumnName,
                    $uapColumnDefinition
                );
            }
        }

        $installer->endSetup();
    }
}
