<?php

namespace Mbe\Shipping\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use \Magento\Framework\DB\Ddl\Table;

class UpgradeSchema implements \Magento\Framework\Setup\UpgradeSchemaInterface
{

    /**
     * @inheritDoc
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {

        if (version_compare($context->getVersion(), '2.3.0', '>=') &&
            version_compare($context->getVersion(), '2.4.0', '<')
        ) {
            $installer = $setup;
            $installer->startSetup();

            $orderTable = $installer->getTable('sales_order');

            $columns = [
                'is_mbe_custom_mapping' => [
                    'type' => Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'default' => false,
                    'comment' => 'MBE Custom mapping shipment order'
                ]
            ];

            $connection = $installer->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($orderTable, $name, $definition);
            }

            $installer->endSetup();
        }

        if (version_compare($context->getVersion(), '2.4.1', '<')
        ) {
            $installer = $setup;
            if ($installer->getConnection()->tableColumnExists($installer->getTable('sales_order'), 'mbe_shipping_uap_shipment') === false) {
                $installer->startSetup();
                $quoteTable = $installer->getTable('quote');
                $orderTable = $installer->getTable('sales_order');

                $columns = [
                    'mbe_shipping_uap_shipment' => [
                        'type' => Table::TYPE_BOOLEAN,
                        'nullable' => false,
                        'default' => false,
                        'comment' => 'MBE Shipment Ship to UAP'
                    ]
                ];

                $connection = $installer->getConnection();

                foreach ($columns as $name => $definition) {
                    $connection->addColumn($quoteTable, $name, $definition);
                    $connection->addColumn($orderTable, $name, $definition);
                }

                $installer->endSetup();
            }
        }

        if (version_compare($context->getVersion(), '2.5', '<')) {
            $installer = $setup;
            $installer->startSetup();
            if (!$installer->tableExists('mbe_shipping_standard_packages')) {
                $table = $installer->getConnection()->newTable(
                    $installer->getTable('mbe_shipping_standard_packages')
                )
                    ->addColumn(
                        'id',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'identity' => true,
                            'nullable' => false,
                            'primary'  => true,
                            'unsigned' => true,
                        ],
                        'Mbe Shipping Custom Package ID'
                    )
                    ->addColumn(
                        'package_code',
                        Table::TYPE_TEXT,
                        50,
                        [
                            'nullable' => false,
                        ]
                    )
                    ->addColumn(
                        'package_label',
                        Table::TYPE_TEXT,
                        255,
                        [
                            'nullable' => false,
                        ]
                    )
                    ->addColumn(
                        'height',
                        Table::TYPE_DECIMAL,
                        [12, 4],
                        [
                            'default' => 0.0000,
                            'nullable' => false
                        ]
                    )
                    ->addColumn(
                        'width',
                        Table::TYPE_DECIMAL,
                        [12, 4],
                        [
                            'default' => 0.0000,
                            'nullable' => false
                        ]
                    )
                    ->addColumn(
                        'length',
                        Table::TYPE_DECIMAL,
                        [12, 4],
                        [
                            'default' => 0.0000,
                            'nullable' => false
                        ]
                    )
                    ->addColumn(
                        'max_weight',
                        Table::TYPE_DECIMAL,
                        [12, 4],
                        [
                            'default' => 0.0000,
                            'nullable' => false
                        ],
                        'Maximum package weight'
                    )
                    ->addIndex(
                        'MBE_PKG_PACKAGE_CODE',
                        ['package_code'],
                        ['type' => \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE]
                    )
                    ->setComment('Mbe Shipping Custom Packages Table');
                $installer->getConnection()->createTable($table);
            }

            if (!$installer->tableExists('mbe_shipping_standard_package_product')) {
                $table = $installer->getConnection()->newTable(
                    $installer->getTable('mbe_shipping_standard_package_product')
                )
                    ->addColumn(
                        'id',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'identity' => true,
                            'nullable' => false,
                            'primary'  => true,
                            'unsigned' => true,
                        ],
                        'Product Package Relation ID'
                    )
                    ->addColumn(
                        'package_code',
                        Table::TYPE_TEXT,
                        50,
                        [
                            'nullable' => false
                        ],
                        'Code of the package'
                    )
                    ->addColumn(
                        'product_sku',
                        Table::TYPE_TEXT,
                        64,
                        [
                            'nullable' => false
                        ],
                        'Product SKU'
                    )
                    ->addColumn(
                        'single_parcel',
                        Table::TYPE_BOOLEAN,
                        null,
                        [
                            'default' => false
                        ],
                        'Product should be shipped as a separate parcel'
                    )
                    ->addColumn(
                        'custom_package',
                        Table::TYPE_BOOLEAN,
                        null,
                        [
                            'default' => false
                        ],
                        'Package is a custom package'
                    )
                    ->addIndex(
                        'MBE_PKG_PROD_PACKAGE_PRODUCT_UNIQUE',
                        ['package_code','product_sku'],
                        ['type' => \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE]
                    )
                    ->addIndex(
                        'MBE_PKG_PROD_PACKAGE_CODE',
                        ['package_code']
                    )
                    ->addIndex(
                        'MBE_PKG_PROD_PRODUCT_SKU',
                        ['product_sku'],
                        ['type' => \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE]
                    )
                    ->setComment('Mbe Shipping Custom Packages for specific products');
                $installer->getConnection()->createTable($table);
            }

            $installer->endSetup();
        }
    }
}
