<?php
namespace Mbe\Shipping\Controller\Adminhtml\Shipments;

use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Model\Ws;

class CloseShipments extends \Magento\Backend\App\Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;
    
    protected $shippingHelper;

    protected $shippingWsFactory;
    
    public function __construct(
        Context $context,
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory
    ) {

        $this->shippingHelper = $shippingHelper;
        $this->shippingWsFactory = $shippingWsFactory;
        
        parent::__construct($context);
    }

    public function execute()
    {
        $shipmentIds = $this->getRequest()->getParam('shipment_ids');
        $toClosedIds = array();
        $alreadyClosedIds = array();

        $helper = $this->shippingHelper;

        /** @var  $ws Ws */
        $ws = $this->shippingWsFactory->create();

        if (!is_array($shipmentIds)) {
            $this->messageManager->addError( __('Please select items.') );
        }
        else {

            foreach ($shipmentIds as $shipmentId) {
                if ($helper->isShippingOpen($shipmentId)) {

                    array_push($toClosedIds, $shipmentId);
                }
                else {
                    array_push($alreadyClosedIds, $shipmentId);
                }
            }

            $ws->closeShipping($toClosedIds);


            if (count($toClosedIds) > 0) {
                $this->messageManager->addSuccess(__('Total of ' . count($toClosedIds) .' shipment(s) have been closed.'));
            }

            if (count($alreadyClosedIds) > 1) {
                $this->messageManager->addError( __('Total of ' . count($alreadyClosedIds) . ' shipment(s) was already closed.'));
            }
        }

        $this->_redirect('*/*/index');
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Backend::content');
    }
}