define([
    'jquery',
    'uiComponent',
    'ko',
    'Magento_Checkout/js/model/quote',
    'mage/url',
], function ($, Component, ko, quote, urlBuilder) {
    'use strict';
    var self
    var checkShipment = ko.observable(false);

    return Component.extend({
        defaults: {
            template: 'Mbe_Shipping/mbe-uap-list-wrapper',
            exports:{
                disableSelectList: 'checkout.steps.shipping-step.shippingAddress.shippingAdditional.mbe-uap-list-wrapper.shipping-option.select-uap:disabled'
            },
        },

        initObservable: function () {
            self = this._super()

            self.checkMethod = ko.computed(function () {
                var method = quote.shippingMethod();

                if (method && method['carrier_code'] !== undefined) {
                    if (method['method_code'].search('SSE') !== -1
                        && method['carrier_code'] === 'mbe_shipping'
                    ) {
                        return true;
                    }
                }
                return false;
            }, this);

            quote.shippingAddress.subscribe(function () {
                let payload = {
                    quoteId: quote.getQuoteId(),
                    countryId: quote.shippingAddress().countryId, // to bypass the missing address issue in controller
                }
                $.ajax({
                    url: urlBuilder.build('mbe/uap/checkshipment'),
                    type: 'get',
                    data: {data:JSON.stringify(payload)},
                    dataType: 'json',
                })
                    .done(function (result) {
                        console.log('done check - '+result)
                        checkShipment(result)
                    })
                    .fail(function () {
                        console.log('fail check')
                        checkShipment(false)
                    })
            }, null, 'change')

            this.showAdditionalOption = ko.computed(function () {
                return !!(self.checkMethod() && checkShipment());
            })

            this.disableSelectList = ko.computed(function () {
                return !this.showAdditionalOption()
            }, this)

            return this;
        }
    });
});
