<?php

namespace Mbe\Shipping\Block\Adminhtml\Order\View;

use Magento\Sales\Api\OrderRepositoryInterface;

class UapDeliveryPoint extends \Magento\Backend\Block\Template
{
    protected $_request;

    protected $orderRepository;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        array $data = [],
        OrderRepositoryInterface $orderRepository
    )
    {
        $this->_request = $context->getRequest();
        $this->orderRepository = $orderRepository;
        parent::__construct($context,$data);
    }

    protected function getOrder() {
        return $this->orderRepository->get($this->_request->getParam('order_id'));
    }

    public function getUapId() {

        $order = $this->getOrder();
        if ($order) {
            return $order->getExtensionAttributes()->getMbeShippingUapShipment()??null;
        }
    }

}
