<?php

namespace Mbe\Shipping\Controller\Adminhtml\System\Config;

use Braintree\Exception;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Response\Http\FileFactory;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Filesystem;
use Magento\Framework\View\Asset\File\NotFoundException;
use Magento\Framework\View\Result\PageFactory;
use Mbe\Shipping\Helper\Data;

class ExportLog extends Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;
    protected $fileSystem;
    protected $fileFactory;
    protected $shippingHelper;
    protected $directoryList;

    public function __construct(
        Context       $context,
        PageFactory   $resultPageFactory,
        Filesystem    $fileSystem,
        FileFactory   $fileFactory,
        Data          $shippingHelper,
        DirectoryList $directoryList
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->fileSystem = $fileSystem;
        $this->fileFactory = $fileFactory;
        $this->shippingHelper = $shippingHelper;
        $this->directoryList = $directoryList;
        parent::__construct($context);
    }

    public function execute()
    {
        try {
            $zipfilepath = $this->directoryList->getPath(DirectoryList::LOG) . DIRECTORY_SEPARATOR . 'log.zip';
            $wslogfilepath = $this->shippingHelper->getLogWsPath();
            $pluginfilepath = $this->shippingHelper->getLogPluginPath();
            $logZip = new \ZipArchive();
            if ($logZip->open($zipfilepath, \ZipArchive::CREATE | \ZipArchive::OVERWRITE) === true) {
                $logZip->addFile($wslogfilepath, substr($wslogfilepath, strrpos($wslogfilepath, '/') + 1));
                $logZip->addFile($pluginfilepath, substr($pluginfilepath, strrpos($pluginfilepath, '/') + 1));
                if ($logZip->count() > 0 && $logZip->close()) {
                    return $this->fileFactory->create(
                        'MbeShippingLog.zip',
                        [
                            'type' => 'filename',
                            'value' => $zipfilepath,
                            'rm' => true
                        ],
                        DirectoryList::LOG,
                        'application/zip'
                    );
                }
            }
            $logZip = null;

            // return error message
            $this->messageManager->addErrorMessage(__('Log files not found'));
        } catch (FileSystemException $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Unexpected error') . ' - ' . $e->getMessage());
        }
        $this->_redirect('adminhtml/system_config/edit/section/carriers/');
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Backend::content');
    }
}
