<?php

namespace Mbe\Shipping\Model\Adminhtml\System\Config\Backend\Shipping;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Filesystem;
use Mbe\Shipping\Helper\Csv;
use Mbe\Shipping\Helper\Data;

class CsvFileToTable extends \Magento\Config\Model\Config\Backend\File
{
    protected $messageManager;
    protected $shippingHelper;
    protected $csvHelper;
    protected $csvHeaderDefinitions = [];
    protected $csvEntityModel;
    protected $csvEntityModelClass;
    protected $fileDriver;
    protected $fileUpdated;

    public function __construct(
        \Magento\Framework\Model\Context                                           $context,
        \Magento\Framework\Registry                                                $registry,
        ScopeConfigInterface                                                       $config,
        \Magento\Framework\App\Cache\TypeListInterface                             $cacheTypeList,
        \Magento\MediaStorage\Model\File\UploaderFactory                           $uploaderFactory,
        \Magento\Config\Model\Config\Backend\File\RequestData\RequestDataInterface $requestData,
        \Magento\Framework\Message\ManagerInterface                                $messageManager,
        Filesystem                                                                 $filesystem,
        Data                                                                       $shippingHelper,
        Csv                                                                        $csvHelper,
        \Mbe\Shipping\Model\csvEntityModelFactory                                  $entityModelFactory,
        \Magento\Framework\Filesystem\Driver\File                                  $fileDriver,
        \Magento\Framework\Model\ResourceModel\AbstractResource                    $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb                              $resourceCollection = null,
        array                                                                      $data = []
    ) {
        $this->messageManager = $messageManager;
        $this->shippingHelper = $shippingHelper;
        $this->csvHelper = $csvHelper;
        $this->fileDriver = $fileDriver;
        $this->csvEntityModel = $entityModelFactory->create($this->csvEntityModelClass);
        $this->fileUpdated = false;
        parent::__construct($context, $registry, $config, $cacheTypeList, $uploaderFactory, $requestData, $filesystem, $resource, $resourceCollection, $data);
    }

    public function beforeSave()
    {
        $value = $this->getValue();
        $file = $this->getFileData();
        $uploadDir = $this->_getUploadDir();

        if (is_array($value) && !empty($value['delete'])) {
            $oldFilePath = $uploadDir.DIRECTORY_SEPARATOR.$value['value'];
            if ($this->fileDriver->isExists($oldFilePath)) {
                $this->fileDriver->deleteFile($oldFilePath);
            }
        }
        if (!empty($file)) {
//            $uploadDir = $this->_getUploadDir();
            try {
                $uploader = $this->_uploaderFactory->create(['fileId' => $file]);
                $uploader->setAllowedExtensions($this->_getAllowedExtensions());
                $uploader->setAllowRenameFiles(true);
                $uploader->addValidateCallback('size', $this, 'validateMaxSize');
                foreach ($this->_getValidationCallbacks() as $name => $method) {
                    $uploader->addValidateCallback($name, $this, $method);
                }
                $result = $uploader->save($uploadDir);
            } catch (\Exception $e) {
                throw new \Magento\Framework\Exception\LocalizedException(__('%1', $e->getMessage()));
            }

            $filename = $result['file'];
            if ($filename) {
                if ($this->_addWhetherScopeInfo()) {
                    $filename = $this->_prependScopeInfo($filename);
                }
                $this->setValue($filename);
            }

            if (!$this->insertIntoTable($uploadDir.DIRECTORY_SEPARATOR.$filename)) {
                throw new \Magento\Framework\Exception\LocalizedException(__('Error while loading CSV to table'));
            }

        } else {
            if (is_array($value) && !empty($value['delete'])) {
                $this->setValue('');
                $truncateResult = $this->csvEntityModel->truncate();
                if (!$truncateResult) {
                    $this->messageManager->addErrorMessage(__('Error executing truncate query '));
                }
                $this->fileUpdated = true;
            } elseif (is_array($value) && !empty($value['value'])) {
                $this->setValue($value['value']);
            } else {
                $this->unsValue();
            }
        }

        return $this;
    }

    protected function insertIntoTable($filePath)
    {
        $truncateResult = $this->csvEntityModel->truncate();
        if (!$truncateResult) {
            $this->messageManager->addErrorMessage(__('Error executing truncate query '));
            return false;
        } else {
            try {
                $rows = $this->csvHelper->readFile($filePath, $this->csvHeaderDefinitions);
                foreach ($rows as $row) {
                    $insertResult = $this->csvEntityModel->insertRow($row);
                    if (!$insertResult) {
                        $this->messageManager->addErrorMessage(__('Error inserting row'));
                        return false;
                    }
                }
            } catch (FileSystemException $exception) {
                $this->messageManager->addErrorMessage(__('Error reading csv file'));
                return false;
            }
        }
        $this->fileUpdated = true;
        return true;
    }

    protected function _getUploadDir()
    {
        return $this->shippingHelper->mbeCsvUploadDir();
    }

    protected function _getAllowedExtensions()
    {
        return ['csv'];
    }

    protected function _getValidationCallbacks()
    {
        return [];
    }
}
