<?php

namespace Mbe\Shipping\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Sales\Model\Order;
use Mbe\Shipping\Helper\Data;

class SalesModelServiceQuoteSubmitBefore implements ObserverInterface
{
    protected $quoteRepository;
    protected $helper;

    public function __construct(
        CartRepositoryInterface $quoteRepository,
        Data                    $helper
    )
    {
        $this->quoteRepository = $quoteRepository;
        $this->helper = $helper;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if ($this->helper->isEnabled()) {
            /** @var $order Order */
            $order = $observer->getOrder();
            $quoteUapShipment = $observer->getEvent()->getQuote()->getExtensionAttributes()->getmbeShippingUapShipment();

            if (!empty($quoteUapShipment)) {
                $order->getExtensionAttributes()->setMbeShippingUapShipment($quoteUapShipment);
                $order->addCommentToStatusHistory('<strong>' . strtoupper(__('Ship to UAP')) . '</strong>');
            }
        }
    }

}