define([
    'jquery',
    'ko',
    'mage/storage',
    'mage/url',
    'uiRegistry',
    'Magento_Customer/js/model/customer',
    'Magento_Ui/js/form/element/select',
    'Magento_Checkout/js/model/quote',
    // 'Magento_Checkout/js/checkout-data',
    // 'Magento_Checkout/js/model/address-converter',
    // 'Magento_Checkout/js/action/create-shipping-address',
    // 'Magento_Checkout/js/action/select-shipping-address',
    // 'Magento_Checkout/js/model/step-navigator',
], function (
    $,
    ko,
    storage,
    urlBuilder,
    registry,
    customer,
    select,
    quote,
    // checkoutData,
    // addressConverter,
    // createShippingAddress,
    // selectShippingAddress,
    // stepNavigator
) {
    'use strict';

    var self;

    return select.extend({
        defaults: {
            tracks:{
                disableSelectList: true
            },
            imports:{
                disableSelectList: 'checkout.steps.shipping-step.shippingAddress.shippingAdditional.mbe-uap-list-wrapper.shipping-option.select-uap:disabled'
            },
            listens:{
                'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.street:value':"updateDropdownValues",
                'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.city:value':"updateDropdownValues",
                'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.country_id:value':"updateDropdownValues",
                'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.region_id:value':"updateDropdownValues",
                'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.postcode:value':"updateDropdownValues"
            }
        },
        initialize: function () {
            self = this;
            this._super();
            this.publicLocationId = ko.observable('')

            ko.getObservable(this,'disableSelectList').subscribe(function(){
                // console.log('disabled')
                self.updateDropdownValues();
            })

            var oldAddress = {}
            quote.shippingAddress.subscribe(function (oldValue) {
                // console.log('beforechange')
                // console.log(oldAddress)
                oldAddress = oldValue
            }, null, 'beforeChange')

            this.value.subscribe(function (newValue) {
                if (newValue != null && newValue !== '') {
                    newValue = JSON.parse(newValue)
                    // this.noRefresh(true)

                    // New address must be selected as a shipping address
                    let addressData = {
                        region_id: '',
                        telephone: quote.shippingAddress().telephone,
                        company: newValue.ConsigneeName,
                        street: [newValue.AddressLine],
                        city: newValue.PoliticalDivision2,
                        country_id: newValue.CountryCode,
                        region: newValue.PoliticalDivision1,
                        postcode: newValue.PostcodePrimaryLow,
                    }

                    if (customer.isLoggedIn()) {
                        // logged in
                        console.log('logged in')
                        addressData.firstname = quote.shippingAddress().firstname
                        addressData.lastname = quote.shippingAddress().lastname

                        // self.updateAddressForm(addressData)
                        //
                        // // this.noRefresh(true)
                        // let newaddress = createShippingAddress(addressData);
                        // selectShippingAddress(newaddress);
                        // checkoutData.setSelectedShippingAddress(newaddress.getKey());
                        // let addressForm = registry.get('checkout.steps.shipping-step.shippingAddress')
                        // // this.noRefresh(true)
                        // this.noRefresh(false)
                        // addressForm.isNewAddressAdded(true)
                    } else { // guest cart
                        console.log('guest')
                        let addressForm = registry.get('checkout.steps.shipping-step.shippingAddress')
                        addressData.firstname = addressForm.source.get('shippingAddress.firstname')
                        addressData.lastname = addressForm.source.get('shippingAddress.lastname')
                        // self.updateAddressForm(addressData)
                        // this.noRefresh(false) // TODO: solo se non aggiorno indirizzo
                    }
                    console.log(newValue.PublicAccesPointID)
                    this.publicLocationId(newValue.PublicAccesPointID)

                }
            }, this)

            // quote.shippingAddress.subscribe(function (value) {
            //     let onlyFields = ['company', 'street', 'city', 'country_id', 'region', 'postcode']
            //     // if (!this.noRefresh() &&
            //     if (!(
            //             (!customer.isLoggedIn()) &&
            //             _.isEqual(_.pick(oldAddress,onlyFields), _.pick(value,onlyFields))
            //         ) &&
            //         !stepNavigator.isProcessed('shipping') // Not on the payment step
            //     ) {
            //         // If we aren't clicking the next step button for a guest quote (shippingaddress is updated)
            //         // we refresh the uap list
            //         // this.publicLocationId('');
            //         self.updateDropdownValues();
            //     }
            // }, this, 'change')
        },

        /**
         * @param value
         * @returns {Object} Chainable
         */
        updateDropdownValues: function () {
            if(!self.disableSelectList) {
                var uapList = [];
                self.updateDropdown(uapList);
                console.log('updatevalue')

                let address = quote.shippingAddress()
                if (address != null) {
                    let filterData = {
                        'AddressLine1': address['street'] != null ? address['street'].join() : '',   //street
                        'PostcodePrimaryLow': address['postcode'],  //zip
                        'PoliticalDivision2': address['city'],      //city
                        'PoliticalDivision1': address['region'],    //state
                        'CountryCode': address['countryId'],       //country
                    }


                    if (self.currentRequest) {
                        self.currentRequest.abort();
                    }
                    return self.currentRequest = $.ajax({
                        url: urlBuilder.build('mbe/uap/getlist'),
                        type: 'get',
                        data: {filter: JSON.stringify(filterData)},
                        dataType: 'json',
                        global: false,
                        beforeSend: function () {
                            self.caption($.mage.__('Loading') + ' ...')
                        }
                    })
                        .done(function (result) {
                            if (result !== null) {
                                _.each(result, function (value, key) {
                                    uapList.push({
                                        label: value.Distance + ' // ' + value.ConsigneeName + ' // ' + value.AddressLine + ' // ' + value.PoliticalDivision2 + ' // ' + value.StandardHoursOfOperation,
                                        value: JSON.stringify(value)
                                    })
                                })
                                self.caption($.mage.__('Select the access point'))
                            } else {
                                self.caption($.mage.__('No UAP found'))
                            }
                        })
                        .fail(function () {
                            self.caption($.mage.__('No UAP found'))
                            console.log("error");
                        })
                        .always(function () {
                            self.updateDropdown(uapList);
                        })
                }
            }
        },

        /**
         * @param value
         * @returns {Object} Chainable
         */
        updateDropdown: function (value) {
            this.setOptions(value).clear();
        },

        updateAddressForm: function (newAddressData) {
            if (newAddressData == null) {
                let newAddressData = {
                    region_id: '',
                    telephone: '',
                    firstname: '',
                    lastname: '',
                    company: '',
                    street: [],
                    city: '',
                    country_id: '',
                    region: '',
                    postcode: '',
                }
            } else {
                let regions = registry.get('checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.region_id')
                let regionId = _.find(regions.indexedOptions, function (val) {
                    let uapregion = newAddressData.region??newAddressData.city
                    return val.label.toLowerCase() === uapregion.toLowerCase()
                })
                if (regionId !== undefined) {
                    newAddressData.region_id = regionId.value
                }
            }
            let addressForm = registry.get('checkout.steps.shipping-step.shippingAddress')
            addressForm.source.set('shippingAddress', newAddressData)

            // * fix for one step checkout - uncheck "save in address book" and "same as billing"
            try {
                if (registry.has('checkout.steps.shipping-step.billingAddress')) {
                    var osform = registry.get('checkout.steps.shipping-step.billingAddress')
                    if (osform.isAddressSameAsShipping !== 'undefined') {
                        osform.isAddressSameAsShipping(false)
                        osform.saveInAddressBook(false)
                        $('#shipping-save-in-address-book').attr('checked', false)
                        // $('#billing-address-same-as-shipping').attr('checked',false)
                    }
                }
            } catch (e) {
                console.log(e.message)
            }
            // * end

            // fix for street name not updated
            try {
                registry.get('checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.street.0').value(newAddressData.street[0])
                registry.get('checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.street.1').value('')
                registry.get('checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset.street.2').value('')
                $('[name="street[0]"]').val(newAddressData.street[0])
            } catch (e) {
                console.log(e.message)
            }
            // console.log('update address form done')
            // this.noRefresh(false)
        }

    });
});