define([
    'jquery',
    'ko',
    'mageUtils',
    'uiComponent',
    'uiLayout',
    'uiRegistry',
    'Magento_Checkout/js/model/address-converter',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/step-navigator'
], function ($, ko, utils, Component, layout, registry, addressConverter, quote,stepNavigator) {
    'use strict';

    var defaultRendererTemplate = {
        parent: '${ $.$data.parentName }',
        name: '${ $.$data.name }',
        component: 'Mbe_Shipping/js/view/shipping-information/address-renderer/default',
        provider: 'checkoutProvider'
    };

    return Component.extend({
        defaults: {
            template: 'Mbe_Shipping/shipping-information/ship-to-uap',
            rendererTemplates: {},
            imports:{
                disableSelectList: 'checkout.steps.shipping-step.shippingAddress.shippingAdditional.mbe-uap-list-wrapper.shipping-option.select-uap:disabled'
            }
        },

        /** @inheritdoc */
        initialize: function () {
            var self = this;

            this._super()
                .initChildren();

            window.addEventListener('hashchange',_.bind(function() {
                if(stepNavigator.isProcessed('shipping')) {
                    let uapAddress = self.getUapAddress()
                    // Check if uap is required when the user is logged in (no address save on state change)
                    if(!uapAddress && !self.disableSelectList) {
                        // validate to show the uap field as required
                        // let addressForm = registry.get('checkout.steps.shipping-step.shippingAddress')
                        // addressForm.source.trigger('shippingAddress.data.validate');
                        // go back to shipment step
                        stepNavigator.navigateTo('shipping')
                    }
                    self.refreshRenderComponent(uapAddress)
                }
            }));

            return this;
        },

        /** @inheritdoc */
        initConfig: function () {
            this._super();
            // the list of child components that are responsible for address rendering
            this.rendererComponents = {};

            return this;
        },

        /** @inheritdoc */
        initChildren: function () {
            return this;
        },


        refreshRenderComponent: function (uapAddress) {
            if(uapAddress) {
                let shiptoAddressesBlock = registry.get('checkout.sidebar.shipping-information.ship-to').rendererComponents
                $.each(shiptoAddressesBlock, function (index, component) {
                    component.visible(false);
                });
                this.createRendererComponent(uapAddress);
            } else {
                // Hide "Ship to UAP" block and refresh "Ship to" block
                let shiptoUapAddressesBlock = registry.get('checkout.sidebar.shipping-information.ship-to-uap').rendererComponents
                $.each(shiptoUapAddressesBlock, function (index, component) {
                    component.visible(false);
                });
                let shiptoAddressesBlock = registry.get('checkout.sidebar.shipping-information.ship-to')
                shiptoAddressesBlock.createRendererComponent(quote.shippingAddress())
            }
        },

        /**
         * Create new component that will render given address in the address list
         *
         * @param {Object} address
         */
        createRendererComponent: function (address) {
            var rendererTemplate, templateData, rendererComponent;
            $.each(this.rendererComponents, function (index, component) {
                component.visible(false);
            });

            if (this.rendererComponents[address.getType()]) {
                this.rendererComponents[address.getType()].address(address);
                this.rendererComponents[address.getType()].visible(true);
            } else {
                // rendererTemplates are provided via layout
                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line
                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :
                    defaultRendererTemplate;
                templateData = {
                    parentName: this.name,
                    // name: address.getType()
                    name: 'new-uap-address'
                };

                rendererComponent = utils.template(rendererTemplate, templateData);
                utils.extend(
                    rendererComponent,
                    {
                        address: ko.observable(address),
                        visible: ko.observable(true),
                        isUap: ko.observable(true), //TODO:Forse non serve
                    }
                );
                layout([rendererComponent]);
                this.rendererComponents[address.getType()] = rendererComponent;
            }
        },

        getUapAddress : function() {
            let uapAddress = (registry.get('checkout.steps.shipping-step.shippingAddress.shippingAdditional.mbe-uap-list-wrapper.shipping-option.select-uap').disabled()?null:(registry.get('checkout.steps.shipping-step.shippingAddress.shippingAdditional.mbe-uap-list-wrapper.shipping-option.select-uap').value()??false))
            if (uapAddress) {
                uapAddress = JSON.parse(uapAddress)
                let addressData = {
                    region_id: '',
                    telephone: quote.shippingAddress().telephone,
                    company: uapAddress.ConsigneeName,
                    street: [uapAddress.AddressLine],
                    city: uapAddress.PoliticalDivision2,
                    country_id: uapAddress.CountryCode,
                    region: uapAddress.PoliticalDivision1,
                    postcode: uapAddress.PostcodePrimaryLow,
                    firstname: quote.shippingAddress().firstname,
                    lastname: quote.shippingAddress().lastname,
                }
                return addressConverter.formAddressDataToQuoteAddress(addressData)
            }
            return false
        }
    });
});