<?php

namespace Mbe\Shipping\Model;

use Magento\Framework\Exception\AlreadyExistsException;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Model\AbstractModel;
use Magento\Sales\Model\Order;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Model\ResourceModel\MbeSalesOrder as ResourceModel;

class MbeSalesOrder extends AbstractModel
{
    /**
     * @var string
     */
    protected $_eventPrefix = 'mbe_sales_order_model';
    protected $mbeSalesOrderResourceModel;
    protected $messageManager;
    protected $shippingHelper;
    protected $shippingWsFactory;
    protected $scopeConfig;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        ManagerInterface                                  $messageManager,
        Data $shippingHelper,
        WsFactory                                     $shippingWsFactory,
        ResourceModel $mbeSalesOrderResourceModel,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->mbeSalesOrderResourceModel = $mbeSalesOrderResourceModel;
        $this->messageManager = $messageManager;
        $this->shippingHelper = $shippingHelper;
        $this->shippingWsFactory = $shippingWsFactory;
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context, $registry);
    }

    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    public function insertRow($row)
    {
        $insertResult = $this->addData($row);
        try {
            $this->mbeSalesOrderResourceModel->save($insertResult);
        } catch (AlreadyExistsException $e) {
            $this->messageManager->addErrorMessage(__('Row already exist in table:').json_encode($row));
            return false;
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Unexpected error') . ': ' . $e->getMessage());
        }
        $this->unsetData();
        return true;
    }

    /**
     * @param $order Order
     * @return bool
     */
    public function setOrderCustomMappingInfo($order)
    {
        try {
            // Add custom mapping flag for shipment list and comment to track it
            if ($this->shippingHelper->isMbeShippingCustomMapping($order->getShippingMethod(true)->getCarrierCode())
                && $order
            ) {

                $orderExtensionAttributes = $order->getExtensionAttributes();
                if (!$orderExtensionAttributes->getIsMbeCustomMapping()) { // check if the flag and comment are alraedy set
                    $ws = $this->shippingWsFactory->create();
                    $orderExtensionAttributes->setIsMbeCustomMapping(true);
//                    $order->setExtensionAttributes($orderExtensionAttributes); // set the custom mapping flag
                    $carrierCode = $order->getShippingMethod(true)->getCarrierCode();
                    $shippingMbeMethod = $this->shippingHelper->getShippingCustomMapping($carrierCode);

                    $availableShipping = $ws->getAvailableShipmentServices();
                    $index = array_search($shippingMbeMethod, array_column($availableShipping, 'value'));
                    if (isset($availableShipping[$index]['label'])) {
                        $customMappingDescription = __($availableShipping[$index]['label'])->getText();
                    }

                    $order->addCommentToStatusHistory(
                        __('Custom mapping for %1', $this->shippingHelper->getCarrierbyCode($carrierCode)).
                        ' - ' .
                        $customMappingDescription
                    );

                    $order->save();
                }
                return true;
            }
        } catch (NoSuchEntityException|InputException $e) {
            return false;
        }
        return false;
    }

}