<?php

namespace Mbe\Shipping\Model\ResourceModel\PackagesProduct;

use Mbe\Shipping\Model\Packages;

class Collection extends \Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection
{
    protected $_idFieldName = 'id';
    protected $_eventPrefix = 'mbe_shipping_standard_package_product_collection';
    protected $_eventObject = 'standard_package_product_collection';

    protected $packagesResourceFactory;

    public function __construct(
        \Magento\Framework\Data\Collection\EntityFactoryInterface    $entityFactory,
        \Psr\Log\LoggerInterface                                     $logger,
        \Magento\Framework\Data\Collection\Db\FetchStrategyInterface $fetchStrategy,
        \Magento\Framework\Event\ManagerInterface                    $eventManager,
        \Mbe\Shipping\Model\ResourceModel\PackagesFactory            $packagesResourceFactory,
        \Magento\Framework\DB\Adapter\AdapterInterface               $connection = null,
        \Magento\Framework\Model\ResourceModel\Db\AbstractDb         $resource = null
    ) {
        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $connection, $resource);
        $this->packagesResourceFactory = $packagesResourceFactory;
    }

    public function getCustomPackageCodes()
    {
        $this->addFieldToSelect('package_code')
            ->getSelect()
            ->where('custom_package = true');
        return $this;
    }

    public function getDuplicatePackages()
    {
        $this->addFieldToSelect('package_code')
            ->getSelect()
            ->group('package_code')
            ->having('count(*) > 1');

        return $this;
    }

    public function getDuplicateProducts()
    {
        $this->addFieldToSelect('product_sku')
            ->getSelect()
            ->group('product_sku')
            ->having('count(*) > 1');

        return $this;
    }

    public function getPackageInfo()
    {
        $packageResource = $this->packagesResourceFactory->create();
        $packages = $packageResource->getMainTable();
        $this->getSelect()
            ->columns(['id_product' => 'main_table.id'])
            ->join(
                $packages,
                "main_table.package_code = $packages.package_code"
            );
        return $this;
    }

    public function getPackageProductWeight()
    {
        $packageResource = $this->packagesResourceFactory->create();
        $packages = $packageResource->getMainTable();
        $this->getSelect()
            ->join(
                $packages,
                "main_table.package_code = $packages.package_code",
                'max_weight'
            );
        return $this;
    }

    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(\Mbe\Shipping\Model\PackagesProduct::class, \Mbe\Shipping\Model\ResourceModel\PackagesProduct::class);
    }

}
