<?php

namespace Mbe\Shipping\Plugin\Model;

use \Magento\Quote\Api\CartRepositoryInterface;
use \Magento\Quote\Api\Data\CartInterface;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Model\ResourceModel\MbeQuote\CollectionFactory as MbeQuoteCollectionFactory;

/** To load extension attributes  */


class CartRepositoryPlugin
{
    protected $mbeQuoteCollectionFactory;
    protected $mbeQuoteModelFactory;
    protected $shippinghelper;

    public function __construct(
        MbeQuoteCollectionFactory           $mbeQuoteCollectionFactory,
        \Mbe\Shipping\Model\MbeQuoteFactory $mbeQuoteModelFactory,
        Data                                $shippinghelper
    )
    {
        $this->mbeQuoteCollectionFactory = $mbeQuoteCollectionFactory;
        $this->mbeQuoteModelFactory = $mbeQuoteModelFactory;
        $this->shippinghelper = $shippinghelper;
    }

    public function afterGet(
        CartRepositoryInterface $subject,
        CartInterface           $resultQuote
    )
    {
        $resultQuote = $this->getMbeAttributes($resultQuote);

        return $resultQuote;
    }

    public function beforeSave(
        CartRepositoryInterface $subject,
        CartInterface           $resultQuote
    )
    {
        $resultQuote = $this->setMbeAttribute($resultQuote, 'mbe_shipping_uap_shipment');

        return [$resultQuote];
    }

    public function afterGetList(
        CartRepositoryInterface                             $subject,
        \Magento\Quote\Api\Data\CartSearchResultsInterface $resultQuote
    )
    {
        /** @var  \Magento\Quote\Model\Quote\Interceptor $quote */
        foreach ($resultQuote->getItems() as $quote) {
            $this->afterGet($subject, $quote);
        }
        return $resultQuote;
    }

    private function setMbeAttribute(CartInterface $quote, $attribute)
    {
        $extensionAttributes = $quote->getExtensionAttributes();
        $getAttribute = 'get' . $this->shippinghelper->strToCamelCase($attribute, '_', true);
        $extensionAttributeValue = $extensionAttributes->$getAttribute();
        try {
            $mbeQuoteCollection = $this->mbeQuoteCollectionFactory->create();
            $mbeQuote = $mbeQuoteCollection->addFieldToFilter('quote_id', $quote->getEntityId())
                ->getFirstItem();
            if (!$mbeQuote->hasData() && null !== $extensionAttributes && null !== $extensionAttributeValue) {
                $insertResult = $this->mbeQuoteModelFactory->create()->insertRow(
                    [
                        $attribute => $extensionAttributeValue,
                        "quote_id" => $quote->getEntityId()
                    ]
                );
                if (!$insertResult) {
                    $this->messageManager->addErrorMessage(__('Error inserting mbe extension attributes for the order'));
                    return false;
                }
            } else if ($mbeQuote->hasData()) {
                $mbeQuote->setData($attribute, $extensionAttributeValue)->save();
            }
        } catch (\Exception $e) {
            throw new CouldNotSaveException(
                __('Could not add attribute to quote: "%1"', $e->getMessage()),
                $e
            );
        }
        return $quote;
    }

    private function getMbeAttributes(CartInterface $quote)
    {

        try {
            $mbeQuote = $this->mbeQuoteCollectionFactory
                ->create()
                ->addFieldToFilter('quote_id', $quote->getEntityId())
                ->getFirstItem();
        } catch (NoSuchEntityException $e) {
            return $quote;
        }

        $extensionAttributes = $quote->getExtensionAttributes();
        $extensionAttributes->setMbeShippingUapShipment($mbeQuote->getData('mbe_shipping_uap_shipment'));

        $quote->setExtensionAttributes($extensionAttributes);

        return $quote;
    }

}