<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Mbe\Shipping\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

/**
 * Patch is mechanism, that allows to do atomic upgrade data changes
 */
class TransferMbeCustomMappingFlag implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface $moduleDataSetup
     */
    private $moduleDataSetup;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * Do Upgrade
     *
     * @return void
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();

        $connection = $this->moduleDataSetup->getConnection();
        $salesOrderTable = $this->moduleDataSetup->getTable('sales_order');
        $mbeSalesOrderTable = $this->moduleDataSetup->getTable('mbe_sales_order');

        if ($connection->tableColumnExists($salesOrderTable, 'is_mbe_custom_mapping')) {
            $select = $connection->select()
                ->from($salesOrderTable)
                ->where('is_mbe_custom_mapping');

            $flaggedOrders = $connection->fetchAll($select);


            // Transfer data from the old column to the new table
            foreach ($flaggedOrders as $order) {
                $connection->insert($mbeSalesOrderTable, [
                    'is_mbe_custom_mapping' => $order['is_mbe_custom_mapping'],
                    'order_id' => $order['entity_id']
                ]);
            }

        }
        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }
}