<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Mbe\Shipping\Setup\Patch\Schema;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\SchemaPatchInterface;
use Mbe\Shipping\Setup\Patch\Data\TransferMbeCustomMappingFlag;

/**
* Patch is mechanism, that allows to do atomic upgrade data changes
*/
class RemoveMbeCustomMappingFlag implements SchemaPatchInterface
{
    /**
     * @var ModuleDataSetupInterface $moduleDataSetup
     */
    private $moduleDataSetup;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * Do Upgrade
     *
     * @return void
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();

        $connection = $this->moduleDataSetup->getConnection();
        $salesOrderTable = $this->moduleDataSetup->getTable('sales_order');

        if ($connection->tableColumnExists($salesOrderTable, 'is_mbe_custom_mapping')) {
            // remove old column from sales_order
            $connection->dropColumn($salesOrderTable, 'is_mbe_custom_mapping');
        }

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [
            TransferMbeCustomMappingFlag::class
        ];
    }
}