<?php

namespace Mbe\Shipping\Setup;

use Magento\Framework\Setup\UninstallInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class Uninstall implements UninstallInterface
{
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        $connection = $installer->getConnection();
        $salesOrderTable = $installer->getTable('sales_order');

        $installer->getConnection()->dropTable($installer->getTable('mbeshippingrate'));
        $installer->getConnection()->dropTable($installer->getTable('mbe_shipping_custom_package'));
        $installer->getConnection()->dropTable($installer->getTable('mbe_shipping_custom_package_item'));
        $installer->getConnection()->dropTable($installer->getTable('mbe_sales_order'));
        $installer->getConnection()->dropTable($installer->getTable('mbe_quote'));

        if ($connection->tableColumnExists($salesOrderTable, 'is_mbe_custom_mapping')) {
            $installer->getConnection()->dropColumn($salesOrderTable, 'is_mbe_custom_mapping');
        }

        if ($connection->tableColumnExists($salesOrderTable, 'mbe_shipping_uap_shipment')) {
            $installer->getConnection()->dropColumn($installer->getTable('quote'), 'mbe_shipping_uap_shipment');
            $installer->getConnection()->dropColumn($salesOrderTable, 'mbe_shipping_uap_shipment');
        }

        $installer->endSetup();
    }
}