<?php

namespace Sartoric\ModularCms\Controllers;

use Sartoric\ModularCms\Helpers\SlugHelper;
use Sartoric\ModularCms\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;

class SlugController extends Controller
{
    public function __construct()
    {
        $this->middleware([]);
    }
    /**
     * Get the entity identified by the slug and run the function set in property $slugShowController
     * @param Request $request
     * @return mixed
     * @throws Exception
     */
    public function show(Request $request)
    {
        $slugItem = SlugHelper::getEntityId($request->slug)->first();
        if (!empty($slugItem)) {
            // New object based on slugitem's class
            $entity = new $slugItem->slugable_type;
            $request->request->add(['entityTo_id' => $slugItem->slugable_id]);
            $request->request->add(['entityTo_type' => $slugItem->slugable_type]);
            $request->request->add(['slug_entity_id' => $slugItem->slugable_id]);
            if (!empty($entity->slugShowController)) {
                return $this->executeAction($entity->slugShowController, [$request]);
            }
            throw new Exception('slugShowController not defined in model '. $slugItem->slugable_type);
        }
        return redirect()->route('frontend.errors', ['code'=>'404'])->with('frontend-errors', 'true');
    }
}
