<?php

namespace Sartoric\ModularCms\Console\Commands;

use Illuminate\Console\Command;

class SlugInit extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mcms:slug:init
                            {model : Model to be initialized}
                            {slugField? : Model\'s field to be used as slug (optional)}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = /** @lang text */
        'Initialize the slug table for a specific Model using the defined <slugField> '.
                             'or a custom field (optional)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $modelName = $this->argument('model');
        $modelSlugField = $this->argument('slugField');

        $entity = new $modelName;
        if ($entity->isSlugable) {
            $modelRows = $entity::all();
            $this->line('');
            $bar = $this->output->createProgressBar(count($modelRows));
            $bar->start();

            $ok=0;
            $ko=0;
            foreach ($modelRows as $row) {
                $value = !empty($modelSlugField)?$row->{$modelSlugField}:null;
                if ($row->setSlug($value)) {
                    $ok++;
                } else {
                    $ko++;
                }
                $bar->advance();
            }
            $bar->finish();
            $this->line('');
            $this->line('');
            $this->line(__('Initialization complete'));
            $this->table(
                ['Slug inserted', 'Slug discarded'],
                [[$ok,$ko]]
            );
        } else {
            $this->error('Model '.$modelName.' is not Slugable. Check if the model uses the trait');
        }
    }
}
