<?php

namespace Sartoric\ModularCms\Helpers;

use Sartoric\ModularCms\Models\Slug;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;

class SlugHelper
{
    /**
     * Return an array or a collection with the ids related to the slug.
     * Entity can be passed as an optional filter as a string or as an object
     * @param $slug
     * @param null $entity string or object
     * @return mixed
     */
    public static function getEntityId($slug, $entity = null)
    {
        $search = Slug::where('slug', $slug);
        if (!empty($entity)) {
            if (!is_string($entity)) {
                $entity = get_class($entity);
            }
            $search = $search->where('slugable_type', $entity);
            return $search->select('slugable_id')->all();
        }
        return $search->select('slugable_id', 'slugable_type')->get();
    }

    /**
     * Check if the slug already exists or not
     * @param $slug
     * @param $entity string or object
     * @param bool $checkDuplicate
     * @return bool
     */
    public static function slugOk($slug, $entity, $checkDuplicate = true)
    {

        // Check registered routes uri
        $routeCollection = Route::getRoutes();
        foreach ($routeCollection as $route) {
            if (preg_match('=^/?('.$slug.')(/.*|/?)=', $route->uri())) {
                return false;
            }
        }
        if ($checkDuplicate) {
            // Check existing slugs
            if (Slug::where('slug', $slug)
                ->where(function ($q) use ($entity) {
                    $q->where('slugable_id', '<>', $entity->getKey())
                        ->orWhere('slugable_type', '<>', get_class($entity));
                })
                ->exists()
            ) {
                return false;
            }
        }
        return true;
    }

    /**
     * @param $param
     * @return bool|string
     */
    public static function generateSlug($param)
    {
        return Str::slug($param);
    }
}
