<?php

namespace Sartoric\ModularCms\Models;

use Sartoric\ModularCms\Helpers\SlugHelper;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slug extends McmsModel
{
    use SoftDeletes;

    public function slugable()
    {
        return $this->morphTo();
    }
    //MUTATORS

    public function setSlugAttribute($input)
    {
        if ($input) {
            $this->attributes['slug'] = SlugHelper::generateSlug($input);
        }
    }
}
