<?php

namespace Sartoric\ModularCms\Helpers;

use Sartoric\ModularCms\Setting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TranslationHelper
{
    public const FRONTEND_LANGUAGE_COOKIE = 'frontend.locale';

    /**
     * @return \Illuminate\Support\Collection
     */
    public static function languages()
    {
        return DB::table('translations_language')->get();
    }

    /**
     * @param $id
     * @return \Illuminate\Database\Query\Builder|mixed
     */
    public static function languageName($id)
    {
        return DB::table('translations_language')->find($id)->name;
    }

    public static function languageIso2Id($iso)
    {
        $language = DB::table('translations_language')->where('iso', $iso)->first();
        if (!empty($language)) {
            return $language->id;
        }
        return null;
    }

    public static function languageId2Iso($id)
    {
        return DB::table('translations_language')->find($id)->iso;
    }

    /**
     * @return \Illuminate\Database\Eloquent\Model|\Illuminate\Database\Query\Builder|object|null
     */
    public static function languageDefault()
    {
        return DB::table('translations_language')->where('default', true)->first();
    }

    /**
     * @param $locale
     */
    public static function setLanguage($locale)
    {
        $language = TranslationHelper::languages()->where('iso', $locale)->first(); //check that the iso exists
        if (!empty($language)) {
            $cookieLocale = Str::camel(Setting::appSetting('appname')) . '.' . self::FRONTEND_LANGUAGE_COOKIE;
            session([$cookieLocale => $language->iso]);
            \App::setLocale($language->iso);
        }
    }

    public static function getLanguage()
    {
        $cookieLocale = Str::camel(Setting::appSetting('appname')) . '.' . self::FRONTEND_LANGUAGE_COOKIE;
        return session()->get($cookieLocale);
    }

    public static function resetLanguage()
    {
        $cookieLocale = Str::camel(Setting::appSetting('appname')) . '.' . self::FRONTEND_LANGUAGE_COOKIE;
        return session()->forget($cookieLocale);
    }

    /**
     * @param $idPage
     * @param $type
     * @param $idLang
     * @return bool
     */
    public static function translationExist($idPage, $type, $idLang)
    {
        return DB::table('translations')
                ->where('id_main', $idPage)
                ->where('id_language', $idLang)
                ->where('translatable_type', $type)
                ->where('deleted_at', null)
                ->count() > 0;
    }
}
