<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_main')->nullable();
            $table->integer('id_language');
            $table->integer('translatable_id');
            $table->string('translatable_type');
            $table->timestamps();
        });

        Schema::create('translations_language', function (Blueprint $table) {
            $table->smallIncrements('id')->unique();
            $table->string('name');
            $table->string('iso', 2);
            $table->boolean('default')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('translations');
        Schema::dropIfExists('translations_language');
    }
}
