<?php

namespace Sartoric\ModularCms\Providers;

use Sartoric\ModularCms\Helpers\Helper;
use Sartoric\ModularCms\Middleware\Frontend\Language;
use Sartoric\ModularCms\Middleware\LockAccount;
use Sartoric\ModularCms\Middleware\ViewRights;

use Illuminate\Support\ServiceProvider;

class McmsTranslationsServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
//  PUBLISH
//        Config
        $this->publishes([
            __DIR__.'/../Config/modularcms.php' => config_path('modularcms.php'),
        ]);
//        Views
        $this->publishes([
            __DIR__.'/../Views' => resource_path('views/vendor/sartoric/modularcms'),
        ], 'developer');
//        Controllers
        $this->publishes([
            __DIR__.'/../Controllers' => app_path('Http/Controllers'),
        ], 'developer');
//        Models
        $this->publishes([
            __DIR__.'/../Models' => app_path(''),
        ], 'developer');
//        Migrations
        $this->publishes([
            __DIR__.'/../Migrations' => database_path('migrations')
        ], 'migrations');
//        Assets
        $this->publishes([
            __DIR__.'/../assets' => public_path(Helper::VENDORPATH.'/assets/'),
        ], 'public');
//        Translations
        $this->publishes([
            __DIR__.'/../translations' => resource_path('lang/vendor/sartoric/modularcms'),
        ], 'public');

//  LOADER
//        Views
        $this->loadViewsFrom(__DIR__.'/../Views', 'sartoric/modularcms');
//        Routes
        $this->loadRoutesFrom(__DIR__.'/../Routes/web.php');
//        Migrations
        $this->loadMigrationsFrom(__DIR__.'/../Migrations');
//        Translations
        $this->loadTranslationsFrom(__DIR__.'/../Translations', 'sartoric/modularcms');

//      Package middleware
        $this->app['router']->aliasMiddleware('frontend.language', Language::class);

        // load package helpers
        $this->loadHelpers();
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // ...
    }

    protected function loadHelpers()
    {
        if (file_exists($file = __DIR__ . '/../Helpers/TranslationHelper.php')) {
            require_once $file;
        }
    }
}
