<?php

namespace Sartoric\ModularCms\Middleware\Frontend;

use Illuminate\Support\Facades\App;
use Sartoric\ModularCms\Helpers\TranslationHelper;
use Sartoric\ModularCms\Helpers\FrontendHelper;
use Sartoric\ModularCms\Models\Settings;
use Closure;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;

class Language
{
    /**
     * Handle an incoming request and set the language cookie if needed and the default locale
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $cookieLocale = Str::camel(Setting::appSetting('appname')).'.'.TranslationHelper::FRONTEND_LANGUAGE_COOKIE;
        $localeNew = $request->route('language');
        // SET THE LANGUAGE
        $feUser = FrontendHelper::feUser();

        if (!empty($localeNew)) {
            TranslationHelper::setLanguage($localeNew);
        } elseif (!empty(TranslationHelper::getLanguage())) {
            // set language by cookie
            TranslationHelper::setLanguage(TranslationHelper::getLanguage());
        } elseif (isset($feUser) && !empty($feUser->language)) {
            // set language by user preference
            TranslationHelper::setLanguage($feUser->language);
        } else {
            // set language by default
            TranslationHelper::setLanguage(App::getLocale());
        }

        // SET DEFAULT LANGUAGE FOR ROUTES
        if (TranslationHelper::getLanguage()) { // should be always true
            URL::defaults(['language' => TranslationHelper::getLanguage()]);
        } else {
            URL::defaults(['language' => App::getLocale()]);
        }
        return $next($request);
    }
}


