<?php

namespace Sartoric\ModularCms\Controllers\Layouts;

use Sartoric\ModularCms\Helpers\TranslationHelper;
use App\Http\Controllers\Controller;
use Sartoric\ModularCms\Models\Translation;
use Exception;
use Illuminate\Support\Facades\DB;

class TranslationController extends Controller
{
    /**
     * @param $parentTransId
     * @param $langId - Language iso code
     * @param $cloner - Function that duplicates the main page, should return Id or throw an exception.
     *        If null, model parameter translationCloner will be used
     *        otherwise an clone record will be created (could fail based on table constraint)
     * @return \Illuminate\Http\RedirectResponse
     * @throws Exception
     */
    public function createTranslation($parentTransId, $langId, $cloner = null)
    {
        $parentTranslation = Translation::findorFail($parentTransId);
        $mainId = $parentTranslation->translatable_id;
        $mainType = $parentTranslation->translatable_type;
        $parentEntity = $parentTranslation->translatable;
        // if language is set and translation page doesn't exists, create it
        try {
            if (isset($langId) && !TranslationHelper::translationExist($mainId, $mainType, $langId)) {
                $translationCloner = $parentEntity->translationCloner;

                if (empty($cloner) && !empty($translationCloner)) {
                    $cloner = $translationCloner;
                } elseif (empty($cloner) && empty($translationCloner)) {
                    DB::transaction(function () use (&$entityTranslated, $parentEntity) {
                        $entityTranslated = $parentEntity->replicate();
                        $entityTranslated->save();
                    });
                    $idTranslation = $entityTranslated->setAsTranslation(TranslationHelper::languageId2Iso($langId), $mainId);
                    if ($idTranslation !== false) {
                        return $this->showEntity($entityTranslated->id, $mainType, $this->notifArray('DB', 'success', __('Traduzione') . ' ' . __('creata con successo')));
                    } else {
                        return back()->with('notify', $this->notifArray('DB', 'error', __('Creazione') . ' ' . __('traduzione') . ' ' . __('fallita')));
                    }
                }
                DB::transaction(function () use (&$entityTranslated, &$idTranslation, $parentEntity, $cloner, $mainId, $langId) {
                    $entityTranslated = $this->executeAction($cloner, [$parentEntity]);
                    $idTranslation = $entityTranslated->setAsTranslation(TranslationHelper::languageId2Iso($langId), $mainId);
                });
                if ($idTranslation !== false) {
                    return $this->showEntity($entityTranslated->id, $mainType, $this->notifArray('DB', 'success', __('Traduzione') . ' ' . __('creata con successo')));
                }
            }
            return back()->with('notify', $this->notifArray('DB', 'error', __('Creazione') . ' ' . __('traduzione') . ' ' . __('fallita')));
        } catch (Exception $err) {
            return back()->with('notify', $this->notifArray('DB', 'error', __('Creazione') . ' ' . __('traduzione') . ' ' . __('fallita')));
        }
    }

    public function showEntity($entityId, $entityType, $notification = null)
    {
        $entity = $entityType::findorFail($entityId);
        $routeTo = $entity->translationEditRoute ?: null;
        if (!is_null($routeTo)) {
            return redirect()->route($routeTo, $entity)->with('notify', $notification);
        } else {
            throw new Exception('translationEditRoute not defined in model ' . $entityType);
        }
    }

    public function deleteEntity($entityId, $entityType)
    {
        $entity = $entityType::findorFail($entityId);
        if (!is_null($entity->translationDelete)) {
            return $this->executeAction($entity->translationDelete, [$entity->id]);
        } else {
            throw new Exception('translationDelete not defined in model ' . $entityType);
        }
    }
}
