@if(!empty($entity->translationRel->id_main))
    <a class="btn btn-circle btn-icon-only btn-default tooltips"
       data-container="body" data-placement="top"
       data-original-title="{{ __('Elimina traduzione') }}"
       data-toggle="dropdown"
       data-href="{{action('Layouts\TranslationController@deleteEntity', [$entity->id, get_class($entity)])}}"
       data-token="{{csrf_token()}}"
       data-method="DELETE"
       data-confirm="1"
       data-submit-confirm-text="{{ __('Vuoi eliminare questa traduzione ?') }}"
       data-submit-confirm-button="{{ __('Si') }}"
    >
        <i class="icon-trash"></i>
    </a>
@endif
<div class="btn-group">
    <a class="btn btn-circle btn-default tooltips"
       data-container="body" data-placement="top"
       data-original-title="{{ __('Traduzioni') }}"
       data-toggle="dropdown">
        {{--                                <i class="icon-globe-alt"></i>--}}
        <span>{{ strtoupper(substr($entity->languageName(), 0, 3)) }}</span>
        <i class="fa fa-angle-down"></i>
    </a>
    <ul class="dropdown-menu pull-right">
        @foreach($entity->translationList() as $idLang=>$idEntity)
            <li @if($entity->id == $idEntity) class="disabled" @endif>
                @if($entity->id == $idEntity)
                    <a href="#" class="disabled font-{{ Sartoric\ModularCms\Models\Setting::appSetting('app-main-color') }}">
                        @else
                            <a @if(empty($idEntity))
                               data-href="{{action('Sartoric\ModularCms\Controllers\Layouts\TranslationController@createTranslation', [$entity->getParentTranslation(), $idLang])}}"
                               data-token="{{csrf_token()}}"
                               data-method="PUT"
                               data-confirm="1"
                               data-submit-confirm-text="{{ __('Vuoi tradurre la pagina ?') }}"
                               data-submit-confirm-button="{{ __('Si') }}"
                               @else
                               href="{{ action('Sartoric\ModularCms\Controllers\Layouts\TranslationController@showEntity', [$idEntity, get_class($entity)]) }}"
                                @endif
                            >
                                @endif
                                {{ __(\Sartoric\ModularCms\Helpers\TranslationHelper::languageName($idLang)) }}
                                @if(!empty($idEntity)) <i class="fa fa-check"></i>@endif
                            </a>
            </li>
        @endforeach
    </ul>
</div>
