<?php

namespace Sartoric\ModularCms\Controllers\Frontend;

use Sartoric\ModularCms\Helpers\TranslationHelper;
use App\Http\Controllers\Controller;
use Sartoric\ModularCms\Models\Translation;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;

class TranslationController extends Controller
{

    public function __construct()
    {
        $this->middleware(['frontend.language']);
    }

    /**
     * Get the entity identified by the translation and run the function set in property $translationShowController
     * @param Request $request
     * @return mixed
     * @throws Exception
     */
    public function show(Request $request)
    {
        // Check if the controller has been called from another pass-through controller (like slug manager) or get the id parameter (to be set in route)
        if ($request->entityTo_id) {
            $entityId = $request->entityTo_id;
            $translationItem = Translation::where('translatable_id', $entityId)->where('translatable_type', $request->entityTo_type)->first();
        } else {
            $entityId = $request->id;
            // TODO : Considerare il caso in cui non si arrivi dallo slug manager (abbiamo un id ma probabilmente non il type che andrebbe passato come parametro nell'url)
        }
        if (!empty($translationItem)) {
            // New object based on translationitem's class
            $entity = $translationItem->translatable_type;
            $entity = $entity::find($translationItem->translatable_id)->getTranslatedItem();
            $request->request->add(['entityTo_id' => $entity->id]);
            $request->request->add(['entityTo_type' => $translationItem->translatable_type]);
            $request->request->add(['translation_entity_id' => $entity->id]);
            if (!empty($entity->translationShowController)) {
                return $this->executeAction($entity->translationShowController, [$request]);
            }
            throw new Exception('TranslationShowController not defined in model ' . $translationItem->translationable_type);
        }
        abort(404);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|mixed
     * @throws Exception
     */
    public function reloadSiteLang(Request $request)
    {
        $locale = $request->language ?: TranslationHelper::languageDefault()->iso;
        $translationFromId = $request->translationFromId ?: false;
        $entityTranslate = true; // for future upgrade

        TranslationHelper::setLanguage($locale);
        if (empty($translationFromId)) {
            $routeTo = request('routeTo');
            $routeParameters = [];
            if (isset($routeTo)) {
                // remove the language (from old route parameters) to be sure the one just set is used
                $routeParameters = array_diff_key(request('routeParam'), array('language'=>''));
            } else {
                $routeTo = 'frontend.home';
            }
            return redirect()->route($routeTo, $routeParameters);
        } elseif ($entityTranslate) {
            $entityTo = Translation::find($translationFromId)->translatable->getTranslatedItem($locale);
            if (!empty($entityTo)) {
                if (!empty($entityTo->translationRedirectController)) {
                    $request->request->add(['entityTo_id' => $entityTo->id]);
                    $request->request->add(['entityTo_type' => get_class($entityTo)]);
                    $request->request->add(['translation_entity_id' => $entityTo->id]);
                    // TODO : va eseguito un redirect o modificata la url in qualche modo (prendere il referrer)
                    return $this->executeAction($entityTo->translationRedirectController, [$request]);
                }
                throw new Exception('translationRedirectController not defined in model ' . $entityTo->slugable_type);
            }
            return redirect()->route('frontend.errors', ['language' => $locale, 'code' => '404'])->with('frontend-errors', 'true');
        }
        return null; // temporaneo
    }

    /** Check if the slug is a locale code, and if there is a page with an equal slug
     * @param $slug
     * @param null $routeTo
     * @return \Illuminate\Http\RedirectResponse
     */
    public function checkLocale($slug, $routeTo = null)
    {
        if (in_array($slug, Arr::pluck(TranslationHelper::languages()->all(), 'iso'))) {
//            TODO: Gestione di controlli opzionali tipo slug da parametrizzare magari passando come parametro
//                  una closure o una call a una funzione di un controller/helper esterno
            // page not found, set locale and load home
            TranslationHelper::setLanguage($slug);
            return redirect()->route('frontend.home');
        }
        // TODO: gestire parametro
        $routeTo = array('routeName'=>'frontend.page', 'parameterName'=>'slug');
        return redirect()->route($routeTo['routeName'], [$routeTo['parameterName'] => $slug]);
    }
}
