<?php
/**
 * Created by   PhpStorm
 * @copyright   Copyright (c) 2020 Cristian Sartori
 * @date:       20/07/20
 * @package
 * @comment
 **/

use Illuminate\Support\Facades\Route;

// Frontend Translation Edit view
Route::get('/translation/{entityId}/{entityType}/{notification?}', 'Layouts\TranslationController@showEntity');
Route::delete('/translation/{entityId}/{entityType}', 'Layouts\TranslationController@deleteEntity');
Route::put('/translation/{parentTransId}/{idlang}', 'Layouts\TranslationController@createTranslation');

// ************** //
// ** FRONTEND ** //
// ************** //
Route::group(['as' => 'frontend.'], function () {
    // -- Switch language
    Route::get('/switch-lang/{language}/{translationFromId?}', 'Frontend\TranslationController@reloadSiteLang')
        ->name('language.switch');
});

