@extends('modularcms::auth.main')

@section('css-page')
    <link href="{{ McmsHelper::mcmsAsset('assets/pages/css/login.min.css')}}" rel="stylesheet" type="text/css" />
@endsection


@section('content')

    <div class="content">
    <!-- BEGIN LOGIN FORM -->
    <form class="login-form" role="form" method="POST" action="{{ route('login') }}">
        {{ csrf_field() }}

        <h3 class="form-title font-green">{{ __('Accedi') }}</h3>
        <div class="alert alert-danger display-hide">
            <button class="close" data-close="alert"></button>
            <span> {{ __('Inserisci username e password') }}</span>
        </div>
        <div class="form-group {{ $errors->has('username') ? ' has-error' : '' }}">
            <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
            <label class="control-label visible-ie8 visible-ie9">{{ __('Username') }}</label>
            <input class="form-control form-control-solid placeholder-no-fix" value="{{ old('username') }}" type="text" autocomplete="off" placeholder="{{ __('Username') }}" name="username" required autofocus/>
        </div>
        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
            <label class="control-label visible-ie8 visible-ie9">{{ __('Password') }}</label>
            <input class="form-control form-control-solid placeholder-no-fix" type="password" autocomplete="off" placeholder="{{ __('Password') }}" name="password" required/>
        </div>
        <div class="form-actions">
            <button type="submit" class="btn green uppercase">{{ __('Entra') }}</button>
            <label class="rememberme check mt-checkbox mt-checkbox-outline">
                <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}> {{__('Ricordami')}}
                <span></span>
            </label>
            <a href="{{ route('password.request') }}" id="forget-password" class="forget-password">{{ __('Dimenticato la password ?') }}</a>
        </div>
        @if(\Sartoric\ModularCms\Models\Setting::appSetting('sociallogin') )
        <div class="login-options">
            <h4>{{ __('o collegati con') }}</h4>
            <ul class="social-icons">
                {{--<li>--}}
                    {{--<a class="social-icon-color facebook" data-original-title="facebook" href="javascript:;"></a>--}}
                {{--</li>--}}
                {{--<li>--}}
                    {{--<a class="social-icon-color twitter" data-original-title="Twitter" href="javascript:;"></a>--}}
                {{--</li>--}}
                {{--<li>--}}
                    {{--<a class="social-icon-color googleplus" data-original-title="Google Plus" href="javascript:;"></a>--}}
                {{--</li>--}}
                {{--<li>--}}
                    {{--<a class="social-icon-color linkedin" data-original-title="Linkedin" href="javascript:;"></a>--}}
                {{--</li>--}}
                <li>
                    <a class="social-icon-color github tooltips" data-container="body" data-placement="bottom" data-original-title="Github" href="{{ route('social.login', 'github') }}"></a>
                </li>
            </ul>
        </div>
        @endif
        @if(count($errors))
            <div class="form-group">
                <div class="alert alert-danger alert-dismissable fade in">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <ul class="list-unstyled">
                        @foreach($errors->all() as $error)
                            <li>{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif
        <div class="create-account">
        </div>
    </form>
    <!-- END LOGIN FORM -->
    </div>

@endsection

@section('plugin-page')

@endsection