// Set no search class for select2
$.fn.select2.defaults.set("theme", "bootstrap");

$(".select2, .select2-multiple").select2({
});

$(".select2-nosearch, .select2-multiple-nosearch").select2({
    minimumResultsForSearch: Infinity
});

// copy Bootstrap validation states to Select2 dropdown
//
// add .has-waring, .has-error, .has-succes to the Select2 dropdown
// (was #select2-drop in Select2 v3.x, in Select2 v4 can be selected via
// body > .select2-container) if _any_ of the opened Select2's parents
// has one of these forementioned classes (YUCK! ;-))
$(".select2, .select2-multiple, .select2-allow-clear, .select2-nosearch, .select2-multiple-nosearch").on("select2:open", function() {
    if ($(this).parents("[class*='has-']").length) {
        var classNames = $(this).parents("[class*='has-']")[0].className.split(/\s+/);

        for (var i = 0; i < classNames.length; ++i) {
            if (classNames[i].match("has-")) {
                $("body > .select2-container").addClass(classNames[i]);
            }
        }
    }
});

// SELECT 2 MATERIAL DESIGN
$( document ).ready(function() {

    const $eventSelect = $(".md-select2");

    $eventSelect.on("select2:open", function () {
        const container = $('body').find('.select2-container--bootstrap .select2-dropdown');
        const isCurrentlyAbove = container.hasClass('select2-dropdown--above');
        const isCurrentlyBelow = container.hasClass('select2-dropdown--below');
        if (isCurrentlyAbove) { console.log(container.css('top')); container.css('top', '+= 34'); console.log(container.css('top')); }
        if (isCurrentlyBelow) { console.log(container.css('top')); container.css('top', '-= 34'); console.log(container.css('top')); }
    });

});