<?php

namespace Sartoric\ModularCms\Policies;

use Sartoric\ModularCms\Models\User;
use Sartoric\ModularCms\Models\Menuitem;
use Illuminate\Auth\Access\HandlesAuthorization;

class MenuitemPolicy
{
    use HandlesAuthorization;

    public function before($user)
    {
        // Only superadmin can manage menuitems
        if ($user->isSuperAdmin()) {
            return true;
        }
        return false;
    }

    /**
     * Determine whether the user can view the menu item.
     *
     * @param  \App\User  $user
     * @param  \App\MenuItem  $menuItem
     * @return mixed
     */
    public function view(User $user, MenuItem $menuItem)
    {
        return false;
    }

    /**
     * Determine whether the user can create menu items.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        return false;
    }

    /**
     * Determine whether the user can update the menu item.
     *
     * @param  \App\User  $user
     * @param  \App\MenuItem  $menuItem
     * @return mixed
     */
    public function update(User $user, MenuItem $menuItem)
    {
        return false;
    }

    /**
     * Determine whether the user can delete the menu item.
     *
     * @param  \App\User  $user
     * @param  \App\MenuItem  $menuItem
     * @return mixed
     */
    public function delete(User $user, MenuItem $menuItem)
    {
        return false;
    }

    /**
     * Determine whether the user can restore the menu item.
     *
     * @param  \App\User  $user
     * @param  \App\MenuItem  $menuItem
     * @return mixed
     */
    public function restore(User $user, MenuItem $menuItem)
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the menu item.
     *
     * @param  \App\User  $user
     * @param  \App\MenuItem  $menuItem
     * @return mixed
     */
    public function forceDelete(User $user, MenuItem $menuItem)
    {
        return false;
    }
}