{{-- HOW TO USE
@include('modularcms::layouts.partials.btndelete', ['buttonmode'=>1 / 0
                                        'formaction'=>'\Sartoric\ModularCms\Controllers\Layouts\UserController',
                                        'idfield'=>$user->id,
                                        'entlabel'=>__('l\'utente'),
                                        'entvalue'=>$user->username
                                        [OPTIONAL]
                                        'customactbtn'=>'some.view.blade'
                                        'activeToggle'=> 1 / 0
                                        ])
--}}


<div class="btn-group">
    <button class="btn btn-no-border btn-outline btn-flat btn-circle grey-salt " data-toggle="dropdown">
        <i class="fa fa-ellipsis-v fa-2x" aria-hidden="true"></i>
    </button>
    <ul class="dropdown-menu pull-right ">
        @can('update', $entity)
            {{--Edit--}}
            <li>
                <a href="{{ action($formaction.'@edit', ['id'=>$idfield]) }}">
                    <i class="icon-pencil"></i> {{ __('Modifica') }}
                </a>
            </li>
        @endcan
        @can('delete', $entity)
            {{--Delete--}}
            @if($buttonmode ?? false)
                <form role="form" class="inline-block" method="post"
                      onsubmit="bbConfirmOnSubmit(event)"
                      action="{{ action($formaction.'@destroy', ['id'=>$idfield])  }}">
                    {{ csrf_field() }}
                    {{ method_field('DELETE') }}
                    <button type="submit" class="btn btn-circle btn-icon-only default tooltips"
                            data-original-title="{{ __('Elimina') }}"
                            data-submit-confirm-text="{{ __('Vuoi eliminare '.$entlabel.' '.$entvalue.' ?') }}"
                            data-submit-confirm-button="{{ __('Ok') }}">
                        &nbsp;<i class="icon-trash"></i>
                    </button>
                </form>
            @else
                <li>
                    <a data-href="{{ action($formaction.'@destroy', ['id'=>$idfield]) }}"
                       data-token="{{csrf_token()}}"
                       data-method="DELETE"
                       data-confirm="1"
                       data-submit-confirm-text="{{ __('Vuoi eliminare '.$entlabel.' '.$entvalue.' ?') }}"
                       data-submit-confirm-button="{{ __('Ok') }}">
                        <i class="icon-trash"></i> {{ __('Elimina') }}
                    </a>
                </li>
            @endif
        @endcan
        @if($activeToggle ?? false)
            @can('update', $entity)
                <li>
                    <a href="{{ action($formaction.'@toggleActive', ['id'=>$idfield]) }}">
                        @if($entity->active)
                            <i class="icon-ban"></i> {{ __('Disattiva') }}
                        @else
                            <i class="icon-check"></i> {{ __('Attiva') }}
                        @endif
                    </a>
                </li>
            @endcan
        @endif
        @if($customactbtn ?? false)
            @component($customactbtn, [
            'idfield'   =>  $idfield,
            'formaction'=>  $formaction,
            'entlabel'  =>  $entlabel,
            'entvalue'  =>  $entvalue,
            'entity'    =>  $entity,
            ])
            @endcomponent
        @endif

    </ul>
</div>