@extends('sartoric/modularcms::auth.main')

@section('content')
    <body class="">
    <div class="page-lock">
        <div class="page-logo">
            <a href="{{  route('home') }}">
                <img src="{{ McmsHelper::mcmsAsset('assets/pages/images/logosmall.png') }}" alt="logo" /> </a>
        </div>
        <div class="page-body">
            <div class="lock-head">{{ __('Bloccato') }}</div>
            <div class="lock-body">
                <div class="lock-cont">
                    <div class="lock-item">
                        <div class="pull-left lock-avatar-block">
                            <img src="{{ McmsHelper::mcmsAsset('assets/pages/images/avatar.png') }}" class="lock-avatar"> </div>
                    </div>
                    <div class="lock-item lock-item-full">
                        <form class="lock-form pull-left" role="form" action="{{ route('lock.post') }}" method="post">
                            {{ csrf_field() }}
                            <h4>{{ auth()->user()->fullname }}</h4>
                            <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                                <label class="control-label visible-ie8 visible-ie9">{{ __('Password') }}</label>
                                <input class="form-control form-control-solid placeholder-no-fix" type="password" autocomplete="off" placeholder="Password" name="password" required/>
                                @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="form-actions">
                                <button type="submit" class="btn uppercase {{ Sartoric\ModularCms\Models\Setting::appSetting('app-main-color') }}">{{ __('Login') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="lock-bottom">
                <a href="" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    {{__('Non sei '). auth()->user()->fullname }} ?
                </a>
            </div>
        </div>
    </div>
    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
        {{ csrf_field() }}
    </form>
    </body>

@endsection

@section('css-page')
    <link href="{{ McmsHelper::mcmsAsset('assets/pages/css/lock.min.css')}}" rel="stylesheet" type="text/css" />
@endsection

@section('plugin-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/pages/scripts/lock.min.js')}}" type="text/javascript"></script>
@endsection


