<?php

namespace Sartoric\ModularCms\Controllers\Auth;

use Illuminate\Http\Request;
use Sartoric\ModularCms\Controllers\Controller;

class LockAccountController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function lockscreen()
    {
        session(['locked' => 'true']);
        return view('sartoric/modularcms::auth.lock');
    }

    public function unlock(Request $request)
    {
        $password = $request->password;
        $this->validate($request, [
            'password' => 'required|string',
        ]);

        if (\Hash::check($password, \Auth::user()->password)) {
            $request->session()->forget('locked');
            return redirect('/home');
        }

        return back()->withErrors(__('Password errata.'));
    }
}