<?php

namespace Sartoric\ModularCms\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct()
    {
        $this->middleware(['auth', 'lock', 'view.rights']);
    }

    public function notifArray($module, $type, $message, $title = false)
    {
        // TODO: Aggiungere push per avere uno stack di notifiche
        return ['module'=>$module, 'type'=>$type, 'message'=>__($message), 'title'=>$title ];
    }
}
