<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMenuitemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sys_menuitems', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('label')->nullable();
            $table->string('link')->nullable();
            $table->smallInteger('position');
            $table->integer('parent');
            $table->boolean('active');
//          active_flg : Campo che contiene il riferimento ad una colonna-flag nelle tabelle sysinfo e user per abilitare o disabilitare alcune funzioni per il singolo utente
//          La colonna in sysinfo abilita il filtro nell'applicazione
//          La colonna in utente abilita/disabiita il menu per l'utente
//          Funzione al momento non attiva perchè gestibile con il multi-ruolo
            //$table->string('active_flg')->nullable();
            $table->boolean('menu');
            $table->string('ico')->nullable();
            $table->boolean('separator');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sys_menuitems');
    }
}


