@extends('sartoric/modularcms::layouts.main')

@include('sartoric/modularcms::layouts.partials.body-tag')


@section('content')
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ __('Impostazioni App') }} </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                            <i class="icon-pencil font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}"></i>
                            <span class="caption-subject bold uppercase"> {{ __('Impostazioni') }}</span>
                        </div>
                    </div>

                    <div class="portlet-body form">
                        <form class="form form-horizontal" action="{{ action('\Sartoric\ModularCms\Controllers\Layouts\SettingController@store') }}" method="post" role="form">
                            {{ csrf_field() }}
                            {{--ID APP "User"--}}
                            <input type="hidden" name="user_id" id="user_id" value="0">

                            <div class="form-body ">
                                <div class="form-group form-md-line-input {{ $errors->has('setting')?' has-error ':'' }}">
                                    <label class="col-md-2 control-label" for="setting"><span class="required">* </span> {{ __('Impostazione') }}</label>
                                    <div class="col-md-9">
                                        <input type="text" class="form-control" id="setting" name="setting">
                                        <div class="form-control-focus"> </div>
                                        <span class="help-block">{{ __('Il codice dell\'impostazione') }}</span>
                                    </div>
                                </div>

                                <div class="form-group form-md-line-input {{ $errors->has('value')?' has-error ':'' }}">
                                    <label class="col-md-2 control-label" for="value"><span class="required">* </span> {{ __('Valore') }}</label>
                                    <div class="col-md-9">
                                        <input type="text" class="form-control" id="value" name="value">
                                        <div class="form-control-focus"> </div>
                                        <span class="help-block">{{ __('Il valore dell\'impostazione') }}</span>
                                    </div>
                                </div>

                                <div class="form-group form-md-line-input {{ $errors->has('label')?' has-error ':'' }}">
                                    <label class="col-md-2 control-label" for="label"><span class="required">* </span> {{ __('Etichetta') }}</label>
                                    <div class="col-md-9">
                                        <input type="text" class="form-control" id="label" name="label">
                                        <div class="form-control-focus"> </div>
                                        <span class="help-block">{{ __('Etichetta dell\'impostazione') }}</span>
                                    </div>
                                </div>

                                <div class="form-group form-md-line-input {{ $errors->has('help')?' has-error ':'' }}">
                                    <label class="col-md-2 control-label" for="help"><span class="required">* </span> {{ __('Help text') }}</label>
                                    <div class="col-md-9">
                                        <input type="text" class="form-control" id="help" name="help">
                                        <div class="form-control-focus"> </div>
                                        <span class="help-block">{{ __('Testo di aiuto per la form di modifica') }}</span>
                                    </div>
                                </div>

                                {{--ATTIVO--}}
                                {{--<div class="form-group form-md-line-input">--}}
                                    {{--<label for="rolelist" class="control-label col-md-2">{{ __('Attivo') }} </label>--}}
                                    {{--<div class="col-md-4">--}}
                                        {{--<div class="md-checkbox-list">--}}
                                            {{--<div class="md-checkbox">--}}
                                                {{--<input type="checkbox" id="active" name="active" class="md-check">--}}
                                                {{--<label for="active">--}}
                                                    {{--<span class="inc"></span>--}}
                                                    {{--<span class="check"></span>--}}
                                                    {{--<span class="box"></span>--}}
                                                {{--</label>--}}
                                            {{--</div>--}}
                                        {{--</div>--}}
                                    {{--</div>--}}
                                {{--</div>--}}

                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-2 col-md-10">
                                        <button type="submit" class="btn {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">{{__('Salva')}}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        @include('sartoric/modularcms::layouts.partials.errors')
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
