

<div class="form-body ">
    <div class="form-group form-md-line-input {{ $errors->has('username')?' has-error ':'' }}">
        <label class="col-md-2 control-label" for="username"><span class="required">* </span> {{ __('Username') }}</label>
        <div class="col-md-9">
            <input @if($action=='edit') disabled @endif type="text" class="form-control" id="username" name="username" value="{{$user->username ?? old('username')}}">
            <div class="form-control-focus"> </div>
            <span class="help-block">{{ __('Username') }}</span>
        </div>
    </div>

    <div class="form-group form-md-line-input {{ $errors->has('fullname')?' has-error ':'' }}">
        <label class="col-md-2 control-label" for="label"><span class="required">* </span> {{ __('Nome completo') }}</label>
        <div class="col-md-9">
            <input type="text" class="form-control" id="fullname" name="fullname" value="{{ $user->fullname ?? old('fullname') }}">
            <div class="form-control-focus"> </div>
            <span class="help-block">{{ __('Il nome completo dell\'utente') }}</span>
        </div>
    </div>

    <div class="form-group form-md-line-input {{ $errors->has('email')?' has-error ':'' }}">
        <label class="col-md-2 control-label" for="email"><span class="required">* </span> {{ __('Email') }}</label>
        <div class="col-md-9">
            <input type="text" class="form-control" id="email" name="email" value="{{ $user->email ?? old('email') }}">
            <div class="form-control-focus"> </div>
            <span class="help-block">{{ __('Indirizzo email dell\'utente') }}</span>
        </div>
    </div>

    <div class="form-group form-md-line-input  {{ $errors->has('password')?' has-error ':'' }}">
        <label class="col-md-2 control-label" for="password">{{ __('Password') }}</label>
        <div class="col-md-9">
            <input type="password" class="form-control pwd-strength" id="password" name="password">
            <div class="form-control-focus"> </div>
            <span class="help-block">{{ __('Inserire una nuova password per aggiornarla') }}</span>
        </div>
    </div>

    {{--RUOLI ATTIVI--}}
    <div class="form-group form-md-line-input">
        <label for="rolelist" class="control-label col-md-2"> <span class="required">* </span> {{ __('Ruoli') }} </label>
        <div class="col-md-9 input-icon right">
            <select @if(auth()->user()->isSuperadmin() || \Sartoric\ModularCms\Models\Setting::appsetting('multirole')) multiple @endif id="rolelist" name="rolelist[]" class="form-control md-select2 select2{{ (auth()->user()->isSuperadmin() || \Sartoric\ModularCms\Models\Setting::appsetting('multirole') )?'-multiple':'' }}-nosearch" data-placeholder="{{ __('Selezionare i ruoli') }}" >
                @foreach($roles as $role)
                    <option value="{{ $role->id }}" {{ $userroles->contains($role->id)?'selected':'' }} >{{ ucwords($role->name) }}</option>
                @endforeach
            </select>
            @if(auth()->user()->isSuperadmin() || \Sartoric\ModularCms\Models\Setting::appsetting('multirole')) <i class="fa fa-caret-down"></i> @endif
        </div>
    </div>

    {{--ATTIVO--}}
    <div class="form-group form-md-line-input">
        <label for="rolelist" class="control-label col-md-2">{{ __('Attivo') }} </label>
        <div class="col-md-4">
            <div class="md-checkbox-list">
                <div class="md-checkbox">
                    <input type="checkbox" id="active" name="active" {{ $user->active?'checked':'' }} class="md-check">
                    <label for="active">
                        <span class="inc"></span>
                        <span class="check"></span>
                        <span class="box"></span>
                    </label>
                </div>
            </div>
        </div>
    </div>

</div>