@extends('sartoric/modularcms::layouts.main')
@include('sartoric/modularcms::layouts.partials.body-tag')

@section('css-page')
   <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
   <!-- BEGIN TABLE PORTLET-->
   <div class="portlet light bordered ">
      <div class="portlet-title">
         <div class="caption">
            <i class="fa fa-cogs"></i>{{ __('Lista menu sidebar') }} </div>
         <div class="actions">
            @can('create', Sartoric\ModularCms\Models\Menuitem::class )
            <a class="btn btn-circle {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}" href="{{ action('\Sartoric\ModularCms\Controllers\Layouts\MenuitemController@create') }}">
               +
            </a>
            @endcan
            <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
               <i class="icon-reload"></i>
            </a>
            <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
               <i class="icon-wrench"></i>
            </a>
         </div>
      </div>
      <div class="portlet-body">
         <table data-toggle="table" class="table table-light table-bordered table-striped table-condensed">
            <thead class="">
            <tr class="uppercase">
               <th class="text-center" data-sortable="true"> {{ __('Etichetta') }} </th>
               <th class="text-center hidden-xs" data-sortable="true"> {{ __('Link/Route') }} </th>
               <th class="text-center hidden-xs" data-sortable="true"> {{ __('Padre') }} </th>
               <th class="text-center hidden-xs hidden-sm hidden-md"> {{ __('Posizione') }} </th>
               <th class="text-center" data-sortable="true"> {{ __('Attivo') }} </th>
               {{--<th class="text-center"> {{ __('Flag attivo') }} </th>--}}
               <th class="text-center hidden-xs hidden-sm"> {{ __('Nel Menu') }} </th>
               <th class="text-center hidden-xs hidden-sm hidden-md"> {{ __('Icona') }} </th>
               <th class="text-center hidden-xs hidden-sm"> {{ __('Separatore') }} </th>
               <th class="text-center"> {{ __('Azioni') }} </th>
            </tr>
            </thead>
            <tbody>
            @foreach($menuitems as $menuitem)
               <tr>
                  <td class="text-center"> {{ ucwords($menuitem->label) }}&nbsp; </td>
                  <td class="text-center hidden-xs"> {{ $menuitem->link }}&nbsp; </td>
                  <td class="text-center hidden-xs"> {{ $parentmenu->find($menuitem->parent)?ucwords($parentmenu->find($menuitem->parent)->label):''}}&nbsp; </td>
                  <td class="text-center hidden-xs hidden-sm hidden-md"> {{ $menuitem->position }}&nbsp; </td>
                  <td class="text-center"> <i class="{{ $menuitem->active?'fa fa-check fa-2x '.'font-'.Sartoric\ModularCms\Models\Setting::appsetting('table-check-color'):'' }}">&nbsp;</i></td>
                  {{--<td class="text-center"> {{ $menuitem->active_flg }}&nbsp; </td>--}}
                  <td class="text-center hidden-xs hidden-sm"> <i class="{{ $menuitem->menu?'fa fa-check fa-2x '.'font-'.Sartoric\ModularCms\Models\Setting::appsetting('table-check-color'):'' }}">&nbsp;</i></td>
                  <td class="text-center hidden-xs hidden-sm hidden-md"> <i class="{{ $menuitem->ico }} "></i>&nbsp; </td>
                  <td class="text-center hidden-xs hidden-sm"> <i class="{{ $menuitem->separator?'fa fa-check fa-2x '.'font-'.Sartoric\ModularCms\Models\Setting::appsetting('table-check-color'):'' }}">&nbsp;</i></td>
                  <td class="text-center">

                     @include('sartoric/modularcms::layouts.partials.actbtnset', ['buttonmode'=>false,
                                                    'formaction'=>'\Sartoric\ModularCms\Controllers\Layouts\MenuitemController',
                                                    'entity'=>$menuitem,
                                                    'idfield'=>$menuitem->id,
                                                    'entlabel'=>__('il menu'),
                                                    'entvalue'=>$menuitem->label,
                                                    'activeToggle'=>false
                                                    ])
                  </td>
               </tr>
            @endforeach
            </tbody>
         </table>
      </div>
   </div>
   <!--END TABLE PORTLET-->
@endsection

@section('plugin-page')
   <script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.js') }}" type="text/javascript"></script>
   <script src="{{ McmsHelper::mcmsAsset('assets/js/anchor-delete.js') }}" type="text/javascript"></script>
@endsection

@section('script-page')
   <script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/table-bootstrap.min.js') }}" type="text/javascript"></script>
@endsection