@extends('sartoric/modularcms::layouts.main')

@include('sartoric/modularcms::layouts.partials.body-tag')


@section('content')

    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ __('Impostazioni App') }} </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                            <i class="icon-pencil font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}"></i>
                            <span class="caption-subject bold uppercase"> {{ __('Impostazioni') }}</span>
                        </div>
                        <div class="actions">
                            @can('create', \Sartoric\ModularCms\Models\User::class )
                                <a href="{{ action('\Sartoric\ModularCms\Controllers\Layouts\SettingController@create') }}" class="btn btn-outline btn-circle btn-sm {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                                    <i class="fa fa-plus"></i> {{ __('Aggiungi') }}
                                </a>
                            @endcan
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <form class="form" action="{{ action('\Sartoric\ModularCms\Controllers\Layouts\SettingController@updateAll') }}" method="post" role="form">
                            {{ csrf_field() }}
                            {{--<legend>{{__('Impostazioni')}}</legend>--}}

                            @foreach($settings as $setting)
                                <div class="form-group form-md-line-input form-md-floating-label">
                                    <input type="text" class="form-control" name="{{ $setting->setting }}" id="{{ $setting->setting }}" value="{{ $setting->value }}">
                                    <label for="{{ $setting->setting }}">{{__($setting->label)}}</label>
                                    <span class="help-block">{{ $setting->help ?? ''}}</span>
                                </div>
                            @endforeach

                            <button type="submit" class="btn btn-primary">{{__('Salva')}}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
