{{-- HOW TO USE
@include('modularcms::layouts.partials.btndelete', ['buttonmode'=>1 / 0
                                        'formaction'=>'Layouts\UserController@destroy',
                                        'idfield'=>$user->id,
                                        'entlabel'=>__('l\'utente'),
                                        'entvalue'=>$user->username
                                        ])
--}}

@if($buttonmode)
<form role="form" class="inline-block" method="post"
      onsubmit="bbConfirmOnSubmit(event)"
      action="{{ action($formaction, ['id'=>$idfield]) }}">
    {{ csrf_field() }}
    {{ method_field('DELETE') }}
    <button type="submit" class="btn btn-circle btn-icon-only default tooltips"
            data-original-title="{{ __('Elimina') }}"
            data-submit-confirm-text="{{ __('Vuoi eliminare '.$entlabel.' '.$entvalue.' ?') }}"
            data-submit-confirm-button="{{ __('Ok') }}">
        &nbsp;<i class="icon-trash"></i>
    </button>
</form>
@else
<li>
    <a data-href="{{ action($formaction, ['id'=>$idfield]) }}"
       data-token="{{csrf_token()}}"
       data-method="DELETE"
       data-confirm="1"
       data-submit-confirm-text="{{ __('Vuoi eliminare '.$entlabel.' '.$entvalue.' ?') }}"
       data-submit-confirm-button="{{ __('Ok') }}">
        <i class="icon-trash"></i> {{ __('Elimina') }}
    </a>
</li>
@endif