@extends('modularcms::layouts.main')
@include('modularcms::layouts.partials.body-tag')

@section('css-page')
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
    <!-- BEGIN TABLE PORTLET-->
    <div class="portlet light bordered ">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-cogs"></i>{{ __('Roles List') }}
            </div>
            <div class="actions">
                @can('create', Sartoric\ModularCms\Models\Role::class )
                <a href="{{ action('\Sartoric\ModularCms\Controllers\Layouts\RoleController@create') }}" class="btn btn-outline btn-circle btn-sm {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                    <i class="fa fa-plus"></i> {{ __('Add') }}
                </a>
                @endcan
            </div>
        </div>
        <div class="portlet-body flip-scroll">
            <table data-toggle="table" class="table table-light table-bordered table-striped table-condensed flip-content">
                <thead class="flip-content">
                <tr class="uppercase">
                    <th class="text-center" data-sortable="true"> {{ __('Role') }} </th>
                    <th class="text-center" data-sortable="true"> {{ __('Description') }} </th>
                    <th class="text-center"> {{ __('Actions') }} </th>
                </tr>
                </thead>
                <tbody>
                @foreach($roles as $role)
                    <tr>
                        <td class="text-center"> {{ ucwords($role->name) }}&nbsp; </td>
                        <td class="text-center"> {{ $role->description }}&nbsp; </td>
                        <td class="text-center">
                            @include('modularcms::layouts.partials.actbtnset', ['buttonmode'=>false,
                                                           'formaction'=>'\Sartoric\ModularCms\Controllers\Layouts\RoleController',
                                                           'entity'=>$role,
                                                           'idfield'=>$role->id,
                                                           'entlabel'=>__('il ruolo'),
                                                           'entvalue'=>$role->name,
                                                           'activeToggle'=>false
                                                           ])
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!--END TABLE PORTLET-->
@endsection

@section('plugin-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.js') }}" type="text/javascript"></script>
    <script src="{{ McmsHelper::mcmsAsset('assets/js/anchor-delete.js') }}" type="text/javascript"></script>
@endsection

@section('script-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/table-bootstrap.min.js') }}" type="text/javascript"></script>
@endsection