<?php

namespace Sartoric\ModularCms\Models;

class Role extends McmsModel
{
    protected $table = 'sys_roles';
    public $timestamps = false;

    // protected $touches = ['users']; // messa solo solo come reminder
    // aggiorna il timestamp dell'utente quando vengono modificati i ruoli

    /**
     * @return \Illuminate\Database\Eloquent\Collection|static|static[]
     */
    public static function approles()
    {
        if (auth()->user()->isSuperAdmin()) {
            return Role::all();
        } else {
            return Role::all()->whereNotIn('name', ['Superadmin','Admin']);
        }
    }

    public function menuitems()
    {
        return $this->belongsToMany(Menuitem::class, 'sys_menuitem_role');
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'sys_role_user');
//          return $this->belongsToMany('App\Users', 'sys_role_user')->using('App\Pivots\Rights');
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'sys_role_permission');
    }

}