<?php
namespace Sartoric\ModularCms\Seeds;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('sys_permissions')->insert(
            array(
                [
                    "id" => 1,
                    "name" => "user-update",
                    "description" => "Aggiornamento utente"
                ],
                [
                    "id" => 2,
                    "name" => "user-create",
                    "description" => "Creazione utenti non admin"
                ],
                [
                    "id" => 3,
                    "name" => "user-sa-update",
                    "description" => "Aggiornamento superadmin"
                ],
                [
                    "id" => 4,
                    "name" => "user-sa-create",
                    "description" => "Creazione di un superadmin"
                ],
                [
                    "id" => 5,
                    "name" => "user-delete",
                    "description" => "Cancellazione di un utente"
                ],
                [
                    "id" => 6,
                    "name" => "user-pwd-update",
                    "description" => "L'utente può cambiare la sua password"
                ],
                [
                    "id" => 7,
                    "name" => "user-profile-view",
                    "description" => "L'utente può vedere la pagina di profilo"
                ],
                [
                    "id" => 8,
                    "name" => "user-profile-edit",
                    "description" => "L'utente può modificare il suo profilo"
                ],
            )
        );
    }
}
