<!DOCTYPE html>

{{--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]--}}
{{--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]--}}
{{--[if !IE]>{{--}}
<html lang="{{ app()->getLocale() }}">
{{--<![endif]--}}
{{-- BEGIN HEAD --}}

<head>
    <meta charset="utf-8" />
    <title>{{ config('app.name', 'Laravel') }}</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="" name="author" />
    {{-- BEGIN GLOBAL MANDATORY STYLES --}}
    {{--Font--}}
    <link href="//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500,700,400" rel="stylesheet" type="text/css" />
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/font-awesome/css/font-awesome.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/simple-line-icons/simple-line-icons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css') }}" rel="stylesheet" type="text/css" />
    {{-- END GLOBAL MANDATORY STYLES --}}
    {{-- BEGIN PAGE LEVEL PLUGINS --}}
    @yield('css-page')
    {{-- END PAGE LEVEL PLUGINS --}}
    {{-- BEGIN THEME GLOBAL STYLES --}}
    <link href="{{ McmsHelper::mcmsAsset('assets/global/css/components-md.min.css') }}" rel="stylesheet" id="style_components" type="text/css" />
    <link href="{{ McmsHelper::mcmsAsset('assets/global/css/plugins-md.min.css') }}" rel="stylesheet" type="text/css" />
    {{-- END THEME GLOBAL STYLES --}}
    {{-- BEGIN THEME LAYOUT STYLES --}}
    <link href="{{ McmsHelper::mcmsAsset('assets/layouts/layout/css/layout.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ McmsHelper::mcmsAsset('assets/layouts/layout/css/themes/light.min.css') }}" rel="stylesheet" type="text/css" id="style_color" />
    {{--CUSTOM CSS (SCSS)--}}
    <link href="{{ McmsHelper::mcmsAsset('assets/layouts/layout/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
    {{-- END THEME LAYOUT STYLES --}}
    <link rel="shortcut icon" href={{ McmsHelper::mcmsAsset("favicon.ico") }} />
</head>
{{-- END HEAD --}}


@yield('body-tag')

<div class="page-wrapper">
    {{-- BEGIN PAGE HEADER--}}
    @include('modularcms::layouts.partials.header')
    {{-- BEGIN CONTAINER --}}
    <div class="page-container">
        {{-- BEGIN SIDEBAR --}}
        @include('modularcms::layouts.partials.sidebar')
        {{-- END SIDEBAR --}}
        {{-- BEGIN CONTENT --}}
        <div class="page-content-wrapper">
            {{-- BEGIN CONTENT BODY --}}
            <div class="page-content">
                @include('modularcms::layouts.partials.breadcrumb')
                @yield('content')
            </div>
            {{-- END CONTENT BODY --}}
        </div>
        {{-- END CONTENT --}}
    </div>
    {{-- END CONTAINER --}}
    @include('modularcms::layouts.partials.footer')
</div>

{{--[if lt IE 9]>

<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/respond.min.js') }}"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/excanvas.min.js') }}"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/ie8.fix.min.js') }}"></script>
<![endif]--}}
{{-- BEGIN CORE PLUGINS --}}
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/jquery.min.js') }}" type="text/javascript"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap/js/bootstrap.min.js') }}" type="text/javascript"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/js.cookie.min.js') }}" type="text/javascript"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js') }}" type="text/javascript"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/jquery.blockui.min.js') }}" type="text/javascript"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js') }}" type="text/javascript"></script>
{{-- END CORE PLUGINS --}}
{{-- BEGIN PAGE LEVEL PLUGINS --}}
<script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootbox/bootbox.min.js') }}" type="text/javascript"></script>
@yield('plugin-page')
{{-- END PAGE LEVEL PLUGINS --}}
{{-- BEGIN THEME GLOBAL SCRIPTS --}}
<script src="{{ McmsHelper::mcmsAsset('assets/global/scripts/app.min.js') }}" type="text/javascript"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/js/custom-fix.js') }}" type="text/javascript"></script>
{{-- END THEME GLOBAL SCRIPTS --}}
{{-- BEGIN PAGE LEVEL SCRIPTS --}}
@yield('script-page')
@include('modularcms::layouts.partials.bootbox')
{{-- END PAGE LEVEL SCRIPTS --}}
{{-- BEGIN THEME LAYOUT SCRIPTS --}}
<script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/layout.min.js') }}" type="text/javascript"></script>
{{--<script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/demo.min.js') }}" type="text/javascript"></script>--}}
<script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/quick-sidebar.min.js') }}" type="text/javascript"></script>
<script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/quick-nav.min.js') }}" type="text/javascript"></script>
{{-- END THEME LAYOUT SCRIPTS --}}
</body>

</html>