@extends('modularcms::layouts.main')
@include('modularcms::layouts.partials.body-tag-solid')

@section('css-page')
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
    <!-- BEGIN TABLE PORTLET-->
    <div class="portlet light bordered ">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-cogs"></i>{{ __('Lista Utenti') }}
            </div>
            <div class="actions">
                @can('create', \Sartoric\ModularCms\Models\User::class )
                    <a href="{{ action('\Sartoric\ModularCms\Controllers\Layouts\UserController@create') }}" class="btn btn-outline btn-circle btn-sm {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                        <i class="fa fa-plus"></i> {{ __('Aggiungi') }}
                    </a>
                @endcan
            </div>
        </div>
        <div class="portlet-body">
            <table data-toggle="table" class="table table-light table-bordered table-striped table-">
                <thead>
                <tr class="uppercase">
                    <th class="text-center" data-sortable="true"> {{ __('Username') }} </th>
                    <th class="text-center hidden-xs hidden-sm" data-sortable="true"> {{ __('Nome') }} </th>
                    <th class="text-center hidden-xs" data-sortable="true"> {{ __('Email') }} </th>
                    <th class="text-center hidden-xs" data-sortable="true"> {{ __('Ruoli') }} </th>
                    <th class="text-center" data-sortable="true"> {{ __('Attivo') }} </th>
                    <th class="text-center"> {{ __('Azioni') }} </th>
                </tr>
                </thead>
                <tbody>
                @foreach($users as $user)
                        <tr>
                            <td class="text-center"> {{ $user->username }}&nbsp; </td>
                            <td class="text-center hidden-xs hidden-sm"> {{ $user->fullname }}&nbsp; </td>
                            <td class="text-center hidden-xs"> {{ $user->email }}&nbsp; </td>
                            <td class="text-center hidden-xs">
                                @foreach($user->roles as $role)
                                    <span class="label label-sm label-default"> {{$role->name}}</span>&nbsp;
                                @endforeach
                            </td>
                            <td class="text-center"> <i class="{{ $user->active?'fa fa-check fa-2x '.'font-'.Sartoric\ModularCms\Models\Setting::appsetting('table-check-color'):'' }}">&nbsp;</i></td>
                            <td class="text-center">

                                @include('modularcms::layouts.partials.actbtnset', ['buttonmode'=>false,
                                                                        'formaction'=>'\Sartoric\ModularCms\Controllers\Layouts\UserController',
                                                                        'entity'=>$user,
                                                                        'idfield'=>$user->id,
                                                                        'entlabel'=>__('l\'utente'),
                                                                        'entvalue'=>$user->username,
                                                                        'activeToggle'=>true
                                                                        ])
                            </td>
                        </tr>
                @endforeach
                </tbody>
            </table>
            {{ $users->links() }}
        </div>
    </div>
    <!--END TABLE PORTLET-->
@endsection

@section('plugin-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.js') }}" type="text/javascript"></script>
    <script src="{{ McmsHelper::mcmsAsset('assets/js/anchor-delete.js') }}" type="text/javascript"></script>
@endsection

@section('script-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/table-bootstrap.min.js') }}" type="text/javascript"></script>
@endsection