<?php

namespace Sartoric\ModularCms\Controllers\Auth;

use Sartoric\ModularCms\Controllers\Controller;
use Laravel\Socialite\Facades\Socialite;

class SocialloginController extends Controller
{

    protected $socialite;

    public function __construct(Socialite $socialite)
    {
        $this->middleware('guest')->except('logout');
        $this->socialite = $socialite;
    }


    public function getSocialAuth($provider = null)
    {
        //just to handle providers that doesn't exist
        if (!config("services.$provider")) {
            abort('404');
        }
        return Socialite::driver($provider)->stateless()->redirect();
        //return $this->socialite->with($provider)->redirect();
    }


    public function getSocialAuthCallback($provider = null)
    {
        if ($user = Socialite::driver($provider)->stateless()->user()) {
            dd($user);
        } else {
            return 'something went wrong';
        }
    }

}