<?php

namespace Sartoric\ModularCms\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Hash;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class User extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;
//    use \Staudenmeir\EloquentHasManyDeep\HasRelationships;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
// DA USARE IN CASO DI AUTO REGISTRAZIONE UTENTE
//    protected $fillable = [
//        'username', 'fullname', 'email', 'password', 'tnc'
//    ];

    protected $guarded = [];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];


    public static function boot()
    {
        parent::boot();

        static::saving(function ($model) {
            if ($model->isDirty()) {
                $model->updated_by = auth()->user()->id;
            }
        });
    }

    public function isSuperAdmin()
    {
        return $this->roles->contains('name', 'Superadmin');
    }

    /**
     * @param array|string $permission
     * @return bool
     */
    public function hasPermission($permission)
    {
        if (is_array($permission)) {
            foreach ($permission as $item) {
                if (!$this->permissions()->contains('name', $item)) {
                    return false;
                }
            }
            return true;
        } else {
            return $this->permissions()->contains('name', $permission);
        }
    }

    public static function appusers()
    {
        if (auth()->user()->isSuperAdmin()) {
            $roles_array = ['Superadmin'];
        } else {
            $roles_array = ['Superadmin','Admin'];
        }

        return User::whereDoesntHave('roles', function ($q) use ($roles_array) {
            $q->whereIn('name', $roles_array);
        })->paginate(20);
    }


//    MUTATORS

    /**
     * Hash password
     * @param $input
     */
    public function setPasswordAttribute($input)
    {
        if ($input) {
            $this->attributes['password'] = app('hash')->needsRehash($input) ? Hash::make($input) : $input;
        }
    }


//    RELATIONSHIP

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'sys_role_user');
//          return $this->hasMany('App\Role', 'sys_role_user')->using('App\Pivots\Rights');
    }

    public function settings()
    {
        return $this->hasMany(Setting::class);
    }

    public function menuitems()
    {
//        return $this->belongsToMany(Menuitem::class, 'view_sys_user_menuitem');
//        return $this->hasManyDeepFromRelations((new Role)->menuitems(), ['sys_role_user', 'App\Role']);
        $menuitems=collect([]);
        foreach ($this->roles as $role) {
            foreach ($role->menuitems as $item) {
                $menuitems->push($item);
            }
        }
        return $menuitems;
    }

    public function permissions()
    {
//        return $this->belongsToMany(Permission::class, 'view_sys_user_permission');
//        return $this->hasManyDeep('App\Permission', ['sys_role_user', 'App\Role']);
        $permissions=collect([]);
        foreach ($this->roles as $role) {
            foreach ($role->permissions as $item) {
                $permissions->push($item);
            }
        }
        return $permissions;
    }
}
