<?php

namespace Sartoric\ModularCms\Policies;

use Sartoric\ModularCms\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class PermissionPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function before(User $user)
    {
        // Only superadmin can manage permissions
        if ($user->isSuperAdmin()) {
            return true;
        }
        return false;
    }

    public function create(User $user, Permission $permission)
    {
        return false;
    }

    public function update(User $user, Permission $permission)
    {
        return false;
    }
    public function delete(User $user, Permission $permission)
    {
        return false;
    }
}
