<?php

namespace Sartoric\ModularCms\Policies;

use Sartoric\ModularCms\Models\User;
use Sartoric\ModularCms\Models\Role;
use Illuminate\Auth\Access\HandlesAuthorization;

class RolePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function before(User $user)
    {
        // Only superadmin can manage roles
        if ($user->isSuperAdmin()) {
            return true;
        }
        return false;
    }

    public function create(User $user, Role $role)
    {
        return false;
    }

    public function update(User $user, Role $role)
    {
        return false;
    }

    public function delete(User $user, Role $role)
    {
        return false;
    }
}
